/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ASYNC_ANNOTATION_PROCESSOR_BEAN_NAME = "org.springframework.scheduling.annotation.internalAsyncAnnotationProcessor";
    public static final String SCHEDULED_ANNOTATION_PROCESSOR_BEAN_NAME = "org.springframework.scheduling.annotation.internalScheduledAnnotationProcessor";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry.containsBeanDefinition(ASYNC_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            parserContext.getReaderContext().error("Only one AsyncAnnotationBeanPostProcessor may exist within the context.", source);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor");
            builder.getRawBeanDefinition().setSource(source);
            String executor = element.getAttribute("executor");
            if (StringUtils.hasText((String)executor)) {
                builder.addPropertyReference("executor", executor);
            }
            AnnotationDrivenBeanDefinitionParser.registerPostProcessor(parserContext, builder, ASYNC_ANNOTATION_PROCESSOR_BEAN_NAME);
        }
        if (registry.containsBeanDefinition(SCHEDULED_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            parserContext.getReaderContext().error("Only one ScheduledAnnotationBeanPostProcessor may exist within the context.", source);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor");
            builder.getRawBeanDefinition().setSource(source);
            String scheduler = element.getAttribute("scheduler");
            if (StringUtils.hasText((String)scheduler)) {
                builder.addPropertyReference("scheduler", scheduler);
            }
            AnnotationDrivenBeanDefinitionParser.registerPostProcessor(parserContext, builder, SCHEDULED_ANNOTATION_PROCESSOR_BEAN_NAME);
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private static void registerPostProcessor(ParserContext parserContext, BeanDefinitionBuilder builder, String beanName) {
        builder.setRole(2);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), beanName);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(holder));
    }
}

