/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.WelcomePage;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;

public class RestServlet
extends DefaultServlet {
    private String userDataPath;
    private String publicDataPath;
    private int cleanUpTriggerLimitPercentage;
    private int cleanUpTargetPercentage;
    private int cleanUpMinimumFileAge;
    private AuthorisedUrlRepository urlRepository;
    private String rootUrl;

    public RestServlet(AuthorisedUrlRepository urlRepository, String rootUrl) {
        this.urlRepository = urlRepository;
        this.rootUrl = rootUrl;
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.userDataPath = configuration.getString("filebroker", "user-data-path");
        this.publicDataPath = configuration.getString("filebroker", "public-data-path");
        this.cleanUpTriggerLimitPercentage = configuration.getInt("filebroker", "clean-up-trigger-limit-percentage");
        this.cleanUpTargetPercentage = configuration.getInt("filebroker", "clean-up-target-percentage");
        this.cleanUpMinimumFileAge = configuration.getInt("filebroker", "clean-up-minimum-file-age");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isValidRequest(request)) {
            super.service(request, response);
        } else {
            response.sendError(404);
        }
    }

    private boolean isValidRequest(HttpServletRequest request) {
        File file = this.locateFile(request);
        if (file.isDirectory()) {
            return false;
        }
        return this.isWelcomePage(request) || this.isUserDataRequest(request) || this.isPublicDataRequest(request);
    }

    private boolean isWelcomePage(HttpServletRequest request) {
        return "/".equals(request.getPathInfo());
    }

    private boolean isUserDataRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return false;
        }
        if (!path.startsWith("/" + this.userDataPath + "/")) {
            return false;
        }
        return this.urlRepository.checkFilenameSyntax(path.substring(("/" + this.userDataPath + "/").length()));
    }

    private boolean isPublicDataRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path != null && path.startsWith("/" + this.publicDataPath + "/");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: GET request for " + request.getRequestURI()));
        }
        if (this.isWelcomePage(request)) {
            new WelcomePage(this.rootUrl).print(response);
        } else {
            File file = this.locateFile(request);
            file.setLastModified(System.currentTimeMillis());
            super.doGet(request, response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean success;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: PUT request for " + request.getRequestURI()));
        }
        if (!this.urlRepository.isAuthorised(this.constructUrl(request))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("PUT denied for " + this.constructUrl(request)));
            }
            response.sendError(403);
            return;
        }
        File file = this.locateFile(request);
        if (file.exists() && !(success = file.delete())) {
            response.sendError(500);
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        ServletInputStream in = request.getInputStream();
        try {
            IO.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            file.delete();
            throw e;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File userDataDir = new File(RestServlet.this.getServletContext().getRealPath(RestServlet.this.userDataPath));
                    long usableSpaceSoftLimit = (long)((double)userDataDir.getTotalSpace() * (double)(100 - RestServlet.this.cleanUpTriggerLimitPercentage) / 100.0);
                    if (userDataDir.getUsableSpace() <= usableSpaceSoftLimit) {
                        Log.info((String)("after put, user data dir soft limit " + usableSpaceSoftLimit + " reached, cleaning up"));
                        Files.makeSpaceInDirectoryPercentage(new File(RestServlet.this.getServletContext().getRealPath(RestServlet.this.userDataPath)), 100 - RestServlet.this.cleanUpTargetPercentage, RestServlet.this.cleanUpMinimumFileAge, TimeUnit.SECONDS);
                        Log.info((String)("after clean up, usable space is: " + new File(RestServlet.this.getServletContext().getRealPath(RestServlet.this.userDataPath)).getUsableSpace()));
                    }
                }
                catch (Exception e) {
                    Log.warn((String)"could not clean up space after put", (Throwable)e);
                }
            }
        }, "chipster-fileserver-cache-cleanup").start();
        response.setStatus(204);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("RESTful file access: DELETE request for " + request.getRequestURI()));
        }
        if (!(file = this.locateFile(request)).exists()) {
            response.sendError(404);
            return;
        }
        boolean success = IO.delete((File)file);
        if (success) {
            response.setStatus(204);
        } else {
            response.sendError(500);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    private File locateFile(HttpServletRequest request) {
        return new File(this.getServletContext().getRealPath(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())));
    }

    private URL constructUrl(HttpServletRequest request) throws MalformedURLException {
        return new URL(this.rootUrl + request.getPathInfo());
    }
}

