/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.biobeans;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.ModuleManager;
import java.io.IOException;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class PhenodataTest {
    private DataManager manager;

    @BeforeSuite(alwaysRun=true)
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        this.manager = new DataManager();
        new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule").plugAll(this.manager, null);
    }

    @Test(groups={"unit"})
    public void testPhenodataRetrieval() throws MicroarrayException, IOException {
        DataBean normalised = this.manager.createDataBean("normalised.tsv");
        DataBean filtered = this.manager.createDataBean("filtered.tsv");
        DataBean filtered2 = this.manager.createDataBean("filtered2.tsv");
        DataBean phenodata = this.manager.createDataBean("phenodata.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised);
        filtered2.addLink(DataBean.Link.DERIVATION, normalised);
        phenodata.addLink(DataBean.Link.ANNOTATION, normalised);
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(normalised, DataBean.Link.ANNOTATION));
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(filtered, DataBean.Link.ANNOTATION));
        Assert.assertEquals((int)2, (int)LinkUtils.retrieveOutputSet(filtered).length);
    }

    @Test(groups={"unit"})
    public void testPhenodataGeneration() throws MicroarrayException, IOException {
        DataBean normalised1 = this.manager.createDataBean("normalised.tsv");
        DataBean phenodata1 = this.manager.createDataBean("phenodata.tsv");
        DataBean filtered = this.manager.createDataBean("filtered.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised1);
        phenodata1.addLink(DataBean.Link.ANNOTATION, normalised1);
        DataBean normalised2 = this.manager.createDataBean("normalised.tsv");
        DataBean phenodata2 = this.manager.createDataBean("phenodata.tsv");
        phenodata2.addLink(DataBean.Link.ANNOTATION, normalised2);
        ArrayList<String> samples = new ArrayList<String>();
        ArrayList<String> originals = new ArrayList<String>();
        ArrayList<String> group = new ArrayList<String>();
        ArrayList<String> training = new ArrayList<String>();
        ArrayList<String> chiptypes = new ArrayList<String>();
        samples.add("microarray1.cel");
        originals.add("affy_example1.cel");
        group.add("1");
        training.add("0");
        chiptypes.add("test3");
        samples.add("microarray2.cel");
        originals.add("affy_example2.cel");
        group.add("2");
        training.add("0");
        chiptypes.add("test3");
        EditableTable matrix = new EditableTable();
        matrix.addColumn("sample", samples);
        matrix.addColumn("original_name", originals);
        matrix.addColumn("group", group);
        matrix.addColumn("training", training);
        matrix.addColumn("chiptype", chiptypes);
        throw new IllegalStateException("Fix these to use DataManager");
    }
}

