/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Transcript;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TranscriptTrack
extends Track {
    private Collection<Gene> genes = new TreeSet<Gene>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private long maxBpLength;

    public TranscriptTrack(View view, DataSource file, long maxBpLength) {
        super(view, file);
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        TreeMap<Region, Transcript> sortedTranscripts = new TreeMap<Region, Transcript>();
        if (this.genes != null) {
            Iterator<Gene> iter = this.genes.iterator();
            while (iter.hasNext()) {
                Gene gene = iter.next();
                if (!gene.getRegion().intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                for (Transcript transcript : gene.getTranscripts()) {
                    sortedTranscripts.put(transcript.getRegion(), transcript);
                }
            }
            ArrayList<RectDrawable> geneDrawables = new ArrayList<RectDrawable>();
            for (Transcript transcript : sortedTranscripts.values()) {
                int i;
                Rectangle rect = new Rectangle();
                int x = rect.x = this.getView().bpToTrack(transcript.getRegion().start).intValue();
                BpCoord endCoord = new BpCoord(transcript.getRegion().end.bp + 1L, transcript.getRegion().end.chr);
                rect.width = this.getView().bpToTrack(endCoord) - rect.x;
                int x2 = this.getView().bpToTrack(endCoord);
                for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x; ++i) {
                }
                int end = rect.x + rect.width;
                if (this.occupiedSpace.size() > i) {
                    this.occupiedSpace.set(i, end);
                } else {
                    this.occupiedSpace.add(end);
                }
                rect.y = (i + 1) * 14;
                int y = rect.y + 2;
                rect.height = 2;
                drawables.add(new LineDrawable(x, y, x2, y, Color.darkGray));
                rect.height = 4;
                if (transcript.getRegion().getStrand() == Strand.REVERSED) {
                    drawables.addAll(this.getArrowDrawables(rect.x, rect.y, -rect.height, rect.height));
                } else {
                    drawables.addAll(this.getArrowDrawables(rect.x + rect.width, rect.y, rect.height, rect.height));
                }
                if (this.isNameVisible(rect)) {
                    String name = null;
                    name = transcript.getName() != null ? transcript.getName() : (transcript.getId() != null ? transcript.getId() : "n/a");
                    this.drawTextAboveRectangle(name, drawables, rect, 1);
                }
                for (Exon exon : transcript.getExons()) {
                    Color c;
                    Exon.Feature feature = exon.getFeature();
                    switch (feature) {
                        case CDS: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        case EXON: {
                            c = PartColor.UTR.c;
                            break;
                        }
                        case START_CODON: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        case STOP_CODON: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        default: {
                            System.err.println("Gene description not recognised: " + (Object)((Object)feature));
                            c = Color.blue;
                        }
                    }
                    rect.x = this.getView().bpToTrack(exon.getRegion().start);
                    BpCoord exonEnd = new BpCoord(exon.getRegion().end.bp + 1L, exon.getRegion().end.chr);
                    rect.width = this.getView().bpToTrack(exonEnd) - rect.x;
                    rect.height = 4;
                    geneDrawables.add(new RectDrawable(rect, c, null));
                }
            }
            Collections.sort(geneDrawables, new Comparator<Drawable>(){

                @Override
                public int compare(Drawable one, Drawable other) {
                    if (one.color.equals(PartColor.CDS.c) && other.color.equals(PartColor.UTR.c)) {
                        return 1;
                    }
                    if (one.color.equals(PartColor.UTR.c) && other.color.equals(PartColor.CDS.c)) {
                        return -1;
                    }
                    return 0;
                }
            });
            drawables.addAll(geneDrawables);
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (areaResult.getStatus().concise || content.region.getStrand() != this.getStrand()) continue;
            Gene gene = (Gene)content.values.get((Object)ColumnType.VALUE);
            this.genes.remove(gene);
            this.genes.add(gene);
        }
        this.getView().redraw();
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.VALUE)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    public static enum PartColor {
        CDS(VisualConstants.COLOR_BLUE),
        UTR(VisualConstants.COLOR_ORANGE);

        public Color c;

        private PartColor(Color c) {
            this.c = c;
        }
    }
}

