/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.SADLTool;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolDescriptionGenerator;
import fi.csc.microarray.analyser.bsh.BeanShellJob;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLGenerator;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BeanShellHandler
implements AnalysisHandler {
    static final Logger logger = Logger.getLogger(BeanShellHandler.class);
    private final String toolPath;

    public BeanShellHandler(HashMap<String, String> parameters) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.toolPath = parameters.get("toolPath");
    }

    @Override
    public AnalysisJob createAnalysisJob(JobMessage message, ToolDescription description, ResultCallback resultHandler) {
        BeanShellJob analysisJob = new BeanShellJob();
        analysisJob.construct(message, description, resultHandler);
        return analysisJob;
    }

    @Override
    public ToolDescription handle(File moduleDir, String toolFilename, Map<String, String> params) throws AnalysisException {
        SADLDescription sadlDescription;
        SADLTool.ParsedScript parsedScript;
        FileInputStream scriptSource;
        File toolFile = new File(moduleDir, this.toolPath + File.separator + toolFilename);
        try {
            scriptSource = new FileInputStream(toolFile);
        }
        catch (FileNotFoundException e) {
            throw new AnalysisException("Script source " + toolFile + " not found.");
        }
        try {
            parsedScript = new SADLTool("//").parseScript(scriptSource);
        }
        catch (IOException e) {
            throw new AnalysisException(e);
        }
        try {
            sadlDescription = new ChipsterSADLParser().parse(parsedScript.SADL, toolFile.getName());
        }
        catch (SADLParser.ParseException e) {
            throw new AnalysisException(e);
        }
        ToolDescription ad = new ToolDescriptionGenerator().generate(sadlDescription, this);
        SADLGenerator.generate(sadlDescription);
        ad.setSADL(SADLGenerator.generate(sadlDescription));
        ad.setCommand("BeanShell");
        ad.setImplementation(parsedScript.source);
        ad.setSourceCode(parsedScript.source);
        ad.setToolFile(toolFile);
        return ad;
    }

    @Override
    public boolean isUptodate(ToolDescription description) {
        File scriptFile = description.getToolFile();
        return scriptFile.lastModified() <= description.getCreationTime();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

