/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.Builder;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipDefinition<Type extends ProcessorDefinition>
extends NoOutputExpressionNode {
    public static final String DEFAULT_DELIMITER = ",";
    @Deprecated
    private String headerName;
    @XmlAttribute
    private String uriDelimiter;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;

    public RoutingSlipDefinition() {
        this((String)null, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName, String uriDelimiter) {
        super(Builder.header(headerName));
        this.setHeaderName(headerName);
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression, String uriDelimiter) {
        super(expression);
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression) {
        this(expression, DEFAULT_DELIMITER);
    }

    public String toString() {
        return "RoutingSlip[headerName=" + this.getHeaderName() + ", uriDelimiter=" + this.getUriDelimiter() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        RoutingSlip routingSlip;
        if (this.getHeaderName() != null) {
            routingSlip = new RoutingSlip(routeContext.getCamelContext(), this.getHeaderName(), this.getUriDelimiter());
        } else {
            Expression expression = this.getExpression().createExpression(routeContext);
            routingSlip = new RoutingSlip(routeContext.getCamelContext(), expression, this.getUriDelimiter());
        }
        if (this.getIgnoreInvalidEndpoint() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.getIgnoreInvalidEndpoint());
        }
        return routingSlip;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.emptyList();
    }

    @Deprecated
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Deprecated
    public String getHeaderName() {
        return this.headerName;
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoints;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }
}

