/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class StringDataFormat
implements DataFormat {
    private final String charset;

    public StringDataFormat(String charset) {
        this.charset = charset;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        String text = ExchangeHelper.convertToType(exchange, String.class, graph);
        byte[] bytes = this.charset != null ? text.getBytes(this.charset) : text.getBytes();
        stream.write(bytes);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        byte[] bytes = ExchangeHelper.convertToType(exchange, byte[].class, stream);
        String answer = this.charset != null ? new String(bytes, this.charset) : new String(bytes);
        return answer;
    }
}

