/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManageable;
import org.icepdf.core.util.MemoryManagerDelegate;

public class MemoryManager {
    private static final Logger logger = Logger.getLogger(MemoryManager.class.toString());
    private static MemoryManager instance;
    protected final Runtime runtime = Runtime.getRuntime();
    protected long minMemory = 5000000L;
    protected long maxMemory;
    protected int purgeSize;
    protected int maxSize;
    protected WeakHashMap locked;
    protected ArrayList leastRecentlyUsed;
    protected long cumulativeDurationManagingMemory;
    protected long cumulativeDurationNotManagingMemory;
    protected long previousTimestampManagedMemory;
    protected int percentageDurationManagingMemory;
    protected ArrayList delegates;

    public static void setInstance(MemoryManager memoryMangaer) {
        instance = memoryMangaer;
    }

    public static MemoryManager getInstance() {
        if (instance == null) {
            instance = new MemoryManager();
        }
        return instance;
    }

    protected MemoryManager() {
        try {
            int t = MemoryManager.parse("org.icepdf.core.minMemory");
            if (t > 0) {
                this.minMemory = t;
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error setting org.icepdf.core.minMemory");
        }
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.purgeSize = Defs.sysPropertyInt("org.icepdf.core.purgeSize", 5);
        this.maxSize = Defs.sysPropertyInt("org.icepdf.core.maxSize", 0);
        this.locked = new WeakHashMap();
        this.leastRecentlyUsed = new ArrayList(256);
        this.delegates = new ArrayList(64);
    }

    public synchronized void lock(Object user, MemoryManageable mm) {
        int numUsed;
        int numUsedMoreThanShould;
        if (user == null || mm == null) {
            return;
        }
        HashSet<MemoryManageable> inUse = (HashSet<MemoryManageable>)this.locked.get(user);
        if (inUse == null) {
            inUse = new HashSet<MemoryManageable>(256);
            this.locked.put(user, inUse);
        }
        inUse.add(mm);
        this.leastRecentlyUsed.remove(mm);
        this.leastRecentlyUsed.add(mm);
        if (this.maxSize > 0 && (numUsedMoreThanShould = (numUsed = this.leastRecentlyUsed.size()) - this.maxSize) > 0) {
            int numToDo = Math.max(this.purgeSize, numUsedMoreThanShould);
            int numDone = this.reduceMemory(numToDo);
        }
    }

    public synchronized void release(Object user, MemoryManageable mm) {
        if (user == null || mm == null) {
            return;
        }
        HashSet inUse = (HashSet)this.locked.get(user);
        if (inUse != null) {
            boolean removed = inUse.remove(mm);
            if (inUse.size() == 0) {
                this.locked.remove(user);
            }
        }
    }

    public synchronized void registerMemoryManagerDelegate(MemoryManagerDelegate delegate) {
        if (!this.delegates.contains(delegate)) {
            this.delegates.add(delegate);
        }
    }

    public synchronized void releaseAllByLibrary(Library library) {
        int i;
        if (library == null) {
            return;
        }
        for (int i2 = this.leastRecentlyUsed.size() - 1; i2 >= 0; --i2) {
            MemoryManageable mm = (MemoryManageable)this.leastRecentlyUsed.get(i2);
            Library lib = mm.getLibrary();
            if (lib == null || !lib.equals(library)) continue;
            this.leastRecentlyUsed.remove(i2);
        }
        ArrayList usersToRemove = new ArrayList();
        Set entries = this.locked.entrySet();
        for (Map.Entry entry : entries) {
            Object user = entry.getKey();
            HashSet inUse = (HashSet)entry.getValue();
            if (inUse == null) continue;
            ArrayList<MemoryManageable> mmsToRemove = new ArrayList<MemoryManageable>();
            for (MemoryManageable mm : inUse) {
                Library lib;
                if (mm == null || (lib = mm.getLibrary()) == null || !lib.equals(library)) continue;
                mmsToRemove.add(mm);
            }
            for (int i3 = 0; i3 < mmsToRemove.size(); ++i3) {
                inUse.remove(mmsToRemove.get(i3));
            }
            mmsToRemove.clear();
            if (inUse.size() != 0) continue;
            usersToRemove.add(user);
        }
        for (i = 0; i < usersToRemove.size(); ++i) {
            this.locked.remove(usersToRemove.get(i));
        }
        usersToRemove.clear();
        for (i = this.delegates.size() - 1; i >= 0; --i) {
            MemoryManagerDelegate mmd = (MemoryManagerDelegate)this.delegates.get(i);
            boolean shouldRemove = false;
            if (mmd == null) {
                shouldRemove = true;
            } else {
                Library lib = mmd.getLibrary();
                if (lib == null) {
                    shouldRemove = true;
                } else if (lib.equals(library)) {
                    shouldRemove = true;
                }
            }
            if (!shouldRemove) continue;
            this.delegates.remove(i);
        }
    }

    protected synchronized boolean reduceMemory() {
        int numToDo = this.purgeSize;
        int aggressive = 0;
        int lruSize = this.leastRecentlyUsed.size();
        if (this.percentageDurationManagingMemory > 15 || lruSize > 100) {
            aggressive = lruSize * 60 / 100;
        } else if (lruSize > 50) {
            aggressive = lruSize * 50 / 100;
        } else if (lruSize > 20) {
            aggressive = lruSize * 40 / 100;
        }
        if (aggressive > numToDo) {
            numToDo = aggressive;
        }
        int numDone = this.reduceMemory(numToDo);
        boolean delegatesReduced = false;
        if (numDone == 0) {
            delegatesReduced = this.reduceMemoryWithDelegates(true);
        } else if (numDone < numToDo) {
            delegatesReduced = this.reduceMemoryWithDelegates(false);
        }
        return numDone > 0 || delegatesReduced;
    }

    protected int reduceMemory(int numToDo) {
        int numDone = 0;
        try {
            int leastRecentlyUsedIndex = 0;
            while (numDone < numToDo && leastRecentlyUsedIndex < this.leastRecentlyUsed.size()) {
                MemoryManageable mm = (MemoryManageable)this.leastRecentlyUsed.get(leastRecentlyUsedIndex);
                if (!this.isLocked(mm)) {
                    mm.reduceMemory();
                    ++numDone;
                    this.leastRecentlyUsed.remove(leastRecentlyUsedIndex);
                    continue;
                }
                ++leastRecentlyUsedIndex;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Problem while reducing memory", e);
        }
        return numDone;
    }

    protected synchronized boolean isLocked(MemoryManageable mm) {
        Set entries = this.locked.entrySet();
        for (Map.Entry entry : entries) {
            HashSet inUse = (HashSet)entry.getValue();
            if (inUse == null || !inUse.contains(mm)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean reduceMemoryWithDelegates(boolean aggressively) {
        int reductionPolicy = aggressively ? 1 : 0;
        boolean anyReduced = false;
        for (int i = 0; i < this.delegates.size(); ++i) {
            MemoryManagerDelegate mmd = (MemoryManagerDelegate)this.delegates.get(i);
            if (mmd == null) continue;
            boolean reduced = mmd.reduceMemory(reductionPolicy);
            anyReduced |= reduced;
        }
        return anyReduced;
    }

    private static final int parse(String memoryValue) {
        String s = Defs.sysProperty(memoryValue);
        if (s == null) {
            return -1;
        }
        int mult = 1;
        char c = s.charAt(s.length() - 1);
        if (c == 'k' || c == 'K') {
            mult = 1024;
            s = s.substring(0, s.length() - 1);
        }
        if (c == 'm' || c == 'M') {
            mult = 0x100000;
            s = s.substring(0, s.length() - 1);
        }
        return mult * Integer.parseInt(s);
    }

    public void setMinMemory(long m) {
        this.minMemory = m;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public void setMaxMemory(long m) {
        this.maxMemory = m;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getFreeMemory() {
        return this.runtime.freeMemory();
    }

    private boolean canAllocate(int bytes, boolean doGC) {
        long mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        long total = this.runtime.totalMemory();
        if (this.maxMemory > total && (mem += this.maxMemory - total) - (long)bytes > this.minMemory) {
            return true;
        }
        if (!doGC) {
            return false;
        }
        System.gc();
        mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        System.runFinalization();
        System.gc();
        mem = this.runtime.freeMemory();
        return mem - (long)bytes > this.minMemory;
    }

    public boolean isLowMemory() {
        return !this.canAllocate(0, true);
    }

    public boolean checkMemory(int memoryNeeded) {
        long beginTime = System.currentTimeMillis();
        int count = 0;
        while (!this.canAllocate(memoryNeeded, count > 0)) {
            boolean reducedSomething = this.reduceMemory();
            if (!reducedSomething && count > 0) {
                this.finishedMemoryProcessing(beginTime);
                return false;
            }
            if (++count <= 10) continue;
            this.finishedMemoryProcessing(beginTime);
            return false;
        }
        this.finishedMemoryProcessing(beginTime);
        return true;
    }

    private void finishedMemoryProcessing(long beginTime) {
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration > 0L) {
            this.cumulativeDurationManagingMemory += duration;
        }
        if (this.previousTimestampManagedMemory != 0L && (duration = beginTime - this.previousTimestampManagedMemory) > 0L) {
            this.cumulativeDurationNotManagingMemory += duration;
        }
        this.previousTimestampManagedMemory = endTime;
        long totalDuration = this.cumulativeDurationManagingMemory + this.cumulativeDurationNotManagingMemory;
        if (totalDuration > 0L) {
            this.percentageDurationManagingMemory = (int)(this.cumulativeDurationManagingMemory * 100L / totalDuration);
        }
    }
}

