/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.hc;

import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.NotAChildException;

public class HCTreeNode {
    private HCTreeNode leftChild;
    private HCTreeNode rightChild;
    private HCTreeNode parent;
    private DataRange dataRange;
    private double height;
    private boolean finalized;

    public HCTreeNode(double height) throws IllegalArgumentException {
        if (height < 0.0) {
            throw new IllegalArgumentException("height given to HCTreeNode() was negative.");
        }
        this.height = height;
        this.dataRange = new DataRange(0, -1);
    }

    public HCTreeNode(double height, int index) throws IllegalArgumentException {
        this.dataRange = new DataRange(index, index);
        this.height = height;
        this.finalized = false;
    }

    private void assertFinalized() {
        if (this.finalized) {
            throw new RuntimeException();
        }
    }

    public HCTreeNode getParent() {
        return this.parent;
    }

    public HCTreeNode getLeftChild() {
        return this.leftChild;
    }

    public HCTreeNode getRightChild() {
        return this.rightChild;
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    public double getHeight() {
        return this.height;
    }

    public HCTreeNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public HCTreeNode getLeafNodeByIndex(int index) throws IndexOutOfBoundsException {
        if (this.dataRange.contains(index)) {
            if (this.leftChild == null && this.rightChild == null) {
                return this;
            }
            if (this.leftChild != null && this.leftChild.getDataRange().contains(index)) {
                return this.leftChild.getLeafNodeByIndex(index);
            }
            return this.rightChild.getLeafNodeByIndex(index);
        }
        if (this.parent == null) {
            throw new IndexOutOfBoundsException("The specified node does not exist in this tree.");
        }
        return this.parent.getLeafNodeByIndex(index);
    }

    private void updateDataRange() throws DataRangeMismatchException {
        this.assertFinalized();
        DataRange newRange = this.leftChild != null ? (DataRange)this.leftChild.getDataRange().clone() : new DataRange(0, -1);
        if (this.rightChild != null) {
            newRange.add(this.rightChild.getDataRange());
        }
        DataRange oldRange = this.dataRange;
        this.dataRange = newRange;
        if (!newRange.equals(oldRange) && this.parent != null) {
            this.parent.updateDataRange();
        }
    }

    public void setLeftChild(HCTreeNode node) throws DataRangeMismatchException {
        this.assertFinalized();
        if (this.leftChild == node) {
            return;
        }
        if (node != null && this.rightChild == node) {
            throw new RuntimeException();
        }
        HCTreeNode oldChild = this.leftChild;
        this.leftChild = node;
        try {
            if (node != null) {
                node.setParent(this);
            }
        }
        catch (NotAChildException e) {
            // empty catch block
        }
        try {
            if (oldChild != null) {
                oldChild.setParent(null);
            }
        }
        catch (NotAChildException notAChildException) {
            // empty catch block
        }
        this.updateDataRange();
    }

    public void setRightChild(HCTreeNode node) throws DataRangeMismatchException {
        this.assertFinalized();
        if (this.rightChild == node) {
            return;
        }
        if (node != null && this.leftChild == node) {
            throw new RuntimeException();
        }
        HCTreeNode oldChild = this.rightChild;
        this.rightChild = node;
        try {
            if (node != null) {
                node.setParent(this);
            }
        }
        catch (NotAChildException e) {
            // empty catch block
        }
        try {
            if (oldChild != null) {
                oldChild.setParent(null);
            }
        }
        catch (NotAChildException notAChildException) {
            // empty catch block
        }
        this.updateDataRange();
    }

    public void setParent(HCTreeNode parent) throws NotAChildException {
        this.assertFinalized();
        if (parent != null && parent.getRightChild() != this && parent.getLeftChild() != this) {
            throw new NotAChildException("parent given to setParent() doesn't have this child.");
        }
        if (this.parent != null) {
            try {
                if (this.parent.getLeftChild() == this) {
                    this.parent.setLeftChild(null);
                } else if (this.parent.getRightChild() == this) {
                    this.parent.setRightChild(null);
                }
            }
            catch (DataRangeMismatchException dataRangeMismatchException) {
                // empty catch block
            }
        }
        this.parent = parent;
    }

    public void finalizeTree() throws IllegalArgumentException {
        if (this.parent != null) {
            throw new IllegalArgumentException("You may only finalize full trees.");
        }
        this.finalizeTreeRecursively(0);
    }

    private int finalizeTreeRecursively(int index) {
        if (this.leftChild == null && this.rightChild == null) {
            if (this.height != 0.0) {
                throw new IllegalArgumentException("Height of a clustering tree leaf node is " + this.height);
            }
            if (!this.dataRange.equals(new DataRange(index, index))) {
                throw new IllegalArgumentException("Expecting index " + index + ", but got range " + this.dataRange);
            }
            return index + 1;
        }
        if (this.leftChild != null && this.rightChild != null) {
            if (this.height < this.leftChild.getHeight() || this.height < this.rightChild.getHeight()) {
                throw new IllegalArgumentException("A height of a node is lower than the height of its child.");
            }
            index = this.leftChild.finalizeTreeRecursively(index);
            index = this.rightChild.finalizeTreeRecursively(index);
            this.finalized = true;
            return index;
        }
        throw new IllegalArgumentException("A clustering tree node must have either zero or two children.");
    }
}

