/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import org.h2.command.Prepared;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorage;
import org.h2.store.fs.FileUtils;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ScriptBase
extends Prepared
implements DataHandler {
    private static final String SCRIPT_SQL = "script.sql";
    protected OutputStream out;
    protected InputStream in;
    private Expression fileNameExpr;
    private String fileName;
    private String cipher;
    private byte[] key;
    private FileStore store;
    private String compressionAlgorithm;

    ScriptBase(Session session) {
        super(session);
    }

    public void setCipher(String string) {
        this.cipher = string;
    }

    private boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(char[] cArray) {
        this.key = SHA256.getKeyPasswordHash("script", cArray);
    }

    public void setFileNameExpr(Expression expression) {
        this.fileNameExpr = expression;
    }

    protected String getFileName() {
        if (this.fileNameExpr != null && this.fileName == null) {
            this.fileName = this.fileNameExpr.optimize(this.session).getValue(this.session).getString();
            if (this.fileName == null || this.fileName.trim().length() == 0) {
                this.fileName = SCRIPT_SQL;
            }
            this.fileName = SysProperties.getScriptDirectory() + this.fileName;
        }
        return this.fileName;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    void deleteStore() {
        String string = this.getFileName();
        if (string != null) {
            FileUtils.delete(string);
        }
    }

    private void initStore() {
        Database database = this.session.getDatabase();
        String string = this.getFileName();
        this.store = FileStore.open(database, string, "rw", this.cipher, this.key);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    void openOutput() {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream outputStream = FileUtils.newOutputStream(string, false);
            this.out = new BufferedOutputStream(outputStream, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, SCRIPT_SQL);
        }
    }

    void openInput() {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.in = new FileStoreInputStream(this.store, this, this.compressionAlgorithm != null, false);
        } else {
            InputStream inputStream;
            try {
                inputStream = FileUtils.newInputStream(string);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string);
            }
            this.in = new BufferedInputStream(inputStream, 4096);
            this.in = CompressTool.wrapInputStream(this.in, this.compressionAlgorithm, SCRIPT_SQL);
            if (this.in == null) {
                throw DbException.get(90124, "script.sql in " + string);
            }
        }
    }

    void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.in);
        this.in = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public String getDatabasePath() {
        return null;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        return null;
    }

    @Override
    public void checkPowerOff() {
        this.session.getDatabase().checkPowerOff();
    }

    @Override
    public void checkWritingAllowed() {
        this.session.getDatabase().checkWritingAllowed();
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.session.getDatabase().getMaxLengthInplaceLob();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.session.getDatabase().getTempFileDeleter();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.session.getDatabase().getLobCompressionAlgorithm(n);
    }

    public void setCompressionAlgorithm(String string) {
        this.compressionAlgorithm = string;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public LobStorage getLobStorage() {
        return null;
    }

    @Override
    public Connection getLobConnection() {
        return null;
    }

    @Override
    public int readLob(long l, long l2, byte[] byArray, int n, int n2) {
        throw DbException.throwInternalError();
    }
}

