# TOOL dimont.R: "Find motifs with Dimont" (Dimont is a universal tool for de-novo motif discovery. Dimont has successfully been applied to ChIP-seq, ChIP-exo and protein-binding microarray (PBM\) data.)
# INPUT seqdata.fa: "Input sequences" TYPE GENERIC (The input sequences for de-novo motif discovery in annotated FastA format. The required format can be generated using the \"Dimont data extractor\".)
# OUTPUT dimont.log: Logfile (Logfile of the Dimont run.)
# OUTPUT dimont-predictions-{...}.txt: Predictions (Binding sites predicted by Dimont.)
# OUTPUT dimont-logo-rc-{...}.png: "Sequence logo (rc\)" (The sequence logo of the reverse complement of the motif discovered by Dimont.)
# OUTPUT dimont-logo-{...}.png: "Sequence logo" (The sequence logo of the motif discovered by Dimont.)
# OUTPUT dimont-model-{...}.xml: "Dimont model" (The model (as XML\) of the motif discovered by Dimont. Can be used in \"Dimont Predictor\".)
# PARAMETER postag: "Position tag" TYPE STRING DEFAULT "peak" (The tag for the position information in the FastA-annotation of the input file, default as generated by \"Dimont data extractor\".)
# PARAMETER valtag: "Value tag" TYPE STRING DEFAULT "signal" (The tag for the value information in the FastA-annotation of the input file, default as generated by \"Dimont data extractor\".)
# PARAMETER OPTIONAL std: "Standard deviation" TYPE DECIMAL FROM 1 DEFAULT 75 (The standard deviation of the position distribution centered at the position specified by the position tag.)
# PARAMETER OPTIONAL wf: "Weighting factor" TYPE DECIMAL FROM 0 TO 1 DEFAULT 0.2 (The value for weighting the data, a value between 0 and 1. Recommended values: 0.2 for ChIP-seq/ChIP-exo, 0.01 for PBM data.)
# PARAMETER OPTIONAL starts: Starts TYPE INTEGER FROM 1 TO 100 DEFAULT 20 (The number of pre-optimization runs. Default value is fine for most applications.)
# PARAMETER OPTIONAL motifwidth: "Initial motif width" TYPE INTEGER FROM 3 TO 30 DEFAULT 15 (The motif width that is used initially, may be adjusted during optimization.)
# PARAMETER OPTIONAL fgOrder: "Markov order of motif model" TYPE INTEGER FROM 0 TO 3 DEFAULT 0 (The Markov order of the model for the motif. A value of 0 (default\) specifies a position weight matrix (PWM\) or position-specific scoring matrix (PSSM\), a value of 1 specifies a weight array matrix (WAM\) model.)
# PARAMETER OPTIONAL bgOrder: "Markov order of background model" TYPE INTEGER FROM -1 TO 5 DEFAULT -1 (The Markov order of the model for the background sequence and the background sequence, -1 defines uniform distribution.)
# PARAMETER OPTIONAL ess: "Equivalent sample size" TYPE DECIMAL FROM 1.0 DEFAULT 4.0 (Reflects the strength of the prior on the model parameters. Default value is fine for most applications.)
# PARAMETER OPTIONAL delete: "Delete BSs from profile" TYPE [yes: yes, no: no] DEFAULT yes (A switch for deleting binding site positions of discovered motifs from the profile before searching for futher motifs.)

system("perl -n -i -e \'if(/^>/) { print \"\\n$_\"; } else { s/\\n//g && print }\' seqdata.fa")

fasta_file <- scan("seqdata.fa", what="list", sep="\n", blank.lines.skip=F)
fasta_len  <- sapply(fasta_file, nchar)
if(min(fasta_len) == 0) {
	remove_lines <- c(which(fasta_len==0) -1, which(fasta_len==0))
	remove_lines <- remove_lines[remove_lines>0]
	fasta_file <- fasta_file[-c(remove_lines)]
}
cat(fasta_file, file="seqdata.fa", sep="\n")

tool<-file.path(chipster.tools.path,"dimont","Dimont.jar");

maxMemoryParameter<-paste("-Xmx", chipster.memory.max, "M", sep="")
command<-paste("java -Xms512M ", maxMemoryParameter, " -Djava.awt.headless=true -jar ",tool,
			   " data=seqdata.fa",
			   " infix=dimont",
			   " position=",postag,
			   " value=",valtag,
			   " sd=",std,
			   " weightingFactor=",wf,
			   " starts=",starts,
			   " motifWidth=",motifwidth,
			   " motifOrder=",fgOrder,
			   " bgOrder=",bgOrder,
			   " ess=",ess,
			   " delete=",delete,
			   " threads=1 > dimont.log",sep="",collapse="");

system(command);
