

package org.jfree.data.hc.junit;

import org.jfree.data.hc.HeatMap;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Some tests for the <code>org.jfree.data</code> package that can be run 
 * using JUnit.  You can find more information about JUnit at 
 * <a href="http://www.junit.org">http://www.junit.org</a>.
 */
public class HeatMapTests extends TestCase {

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HeatMapTests(String name) {
        super(name);
    }

    /**
    /**
     * Returns a test suite to the JUnit test runner.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HeatMapTests.class);
    }

    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    /**
     * tests normal heatmap
     */
    public void testNormalHeatMap() {

	int i;
	String[] names;
	HeatMap heatMap;

	heatMap = new HeatMap("",5,5);
	for (i = 0; i < heatMap.getColumnsCount(); i++) {
	    heatMap.setColumnName(i,""+i);
	    assertTrue(heatMap.getColumnName(i).equals(""+i));
	}
	for (i = 0; i < heatMap.getRowCount(); i++) {
	    heatMap.setRowName(i,""+i);
	    assertTrue(heatMap.getRowName(i).equals(""+i));
	}

	names = heatMap.getRowNames();

	for (i = 0; i < heatMap.getRowCount(); i++) {
	    assertTrue(names[i].equals(""+i));
	}

	names = heatMap.getColumnNames();

	for (i = 0; i < heatMap.getColumnsCount(); i++) {
	    assertTrue(names[i].equals(""+i));
	}

    }

    /**
     * tests empty heatmap
     */
    public void testEmptyHeatMap() {

	try {
	    HeatMap heatMap = new HeatMap("",0,0);
	    assertTrue(false);
	} catch (ArrayIndexOutOfBoundsException e) {
	    ;
	}


    }

}
