/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.table;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProvider;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.features.table.DynamicallyParsedTable;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.LookaheadLineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TableColumnProvider
extends FeatureProviderBase {
    private static final Logger logger = Logger.getLogger(TableColumnProvider.class);
    private static final Pattern ROW_TOKENISER_REGEX = Pattern.compile("\t");

    @Override
    public Feature createFeature(String namePostfix, DataBean bean) {
        try {
            return new TableColumn(namePostfix, bean, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage() + " (when parsing table data out of " + bean.getName() + ")", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixParseSettings inferSettings(DataBean bean) throws IOException, MicroarrayException {
        MatrixParseSettings matrixParseSettings;
        BufferedReader bufferedReader = null;
        try {
            String[] columnNames;
            bufferedReader = new BufferedReader(new InputStreamReader(bean.getContentByteStream()));
            LookaheadLineReader source = new LookaheadLineReader(bufferedReader);
            MatrixParseSettings settings = new MatrixParseSettings();
            if (source.peekLine() != null && source.peekLine().contains("[CEL]")) {
                logger.debug((Object)"parsing cel type");
                TableColumnProvider.searchHeaderTerminator(settings, "CellHeader=", source);
                settings.footerStarter = "\n[MASKS]";
                settings.hasColumnNames = true;
            } else {
                logger.debug((Object)"parsing generic type");
                settings.hasColumnNames = bean.hasTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
                if (bean.hasTypeTag(BasicModule.TypeTags.TABLE_WITH_HEADER_ROW)) {
                    settings.headerBytes = source.peekLine(1).length() + 1;
                }
                if (bean.hasTypeTag(MicroarrayModule.TypeTags.TABLE_WITH_HASH_HEADER)) {
                    TableColumnProvider.searchHeaderRows(settings, "#", source);
                }
                if (bean.hasTypeTag(MicroarrayModule.TypeTags.TABLE_WITH_DOUBLE_HASH_HEADER)) {
                    TableColumnProvider.searchHeaderRows(settings, "##", source);
                }
                logger.debug((Object)("first line has " + TableColumnProvider.tokeniseRow(source.peekLine(1)).length + " tokens and is " + source.peekLine(1)));
                logger.debug((Object)("second line has " + TableColumnProvider.tokeniseRow(source.peekLine(2)).length + " tokens and is " + source.peekLine(2)));
            }
            if (settings.headerBytes != 0L) {
                TableColumnProvider.parseAwayHeader(source, settings);
            }
            if (settings.hasColumnNames) {
                logger.debug((Object)("column name row " + source.peekLine()));
                columnNames = TableColumnProvider.tokeniseRow(source.readLine());
            } else {
                logger.debug((Object)"no column names, we use numbering");
                columnNames = new String[TableColumnProvider.tokeniseRow(source.peekLine()).length];
                for (int i = 0; i < columnNames.length; ++i) {
                    columnNames[i] = "column" + i;
                }
            }
            int dataColumnCount = TableColumnProvider.tokeniseRow(source.peekLine(1)).length;
            if (dataColumnCount == columnNames.length + 1) {
                logger.debug((Object)"we have one column for row names");
                String[] newColumnNames = new String[columnNames.length + 1];
                System.arraycopy(columnNames, 0, newColumnNames, 1, columnNames.length);
                newColumnNames[0] = " ";
                columnNames = newColumnNames;
            }
            logger.debug((Object)("parsed matrix has " + columnNames.length + " columns, column names came with data: " + settings.hasColumnNames));
            for (String columnName : columnNames = TableColumnProvider.makeUnique(Arrays.asList(columnNames)).toArray(new String[0])) {
                logger.debug((Object)("added column " + columnName));
                settings.columns.put(columnName, new Column(columnName));
            }
            matrixParseSettings = settings;
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(bufferedReader);
            throw throwable;
        }
        IOUtils.closeIfPossible(bufferedReader);
        return matrixParseSettings;
    }

    private static List<String> makeUnique(List<String> originalNames) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String name : originalNames) {
            String candidate = name;
            if (uniqueNames.contains(candidate)) {
                int i = 1;
                while (uniqueNames.contains(candidate = name + "_" + ++i)) {
                }
            }
            uniqueNames.add(candidate);
        }
        return uniqueNames;
    }

    private static void searchHeaderTerminator(MatrixParseSettings settings, String terminator, LookaheadLineReader source) throws IOException {
        long headerBytes = 0L;
        String line = "";
        int i = 1;
        while (line != null) {
            String nextLine = source.peekLine(i);
            if (nextLine.contains(terminator)) {
                headerBytes += (long)(nextLine.indexOf(terminator) + terminator.length());
                break;
            }
            line = nextLine;
            headerBytes += (long)(line.length() + 1);
            ++i;
        }
        settings.headerBytes = headerBytes;
    }

    private static void searchHeaderRows(MatrixParseSettings settings, String headerSymbol, LookaheadLineReader source) throws IOException {
        String nextLine;
        long headerBytes = 0L;
        String line = "";
        int i = 1;
        while (line != null && (nextLine = source.peekLine(i)).startsWith(headerSymbol)) {
            line = nextLine;
            headerBytes += (long)(line.length() + 1);
            ++i;
        }
        settings.headerBytes = headerBytes;
    }

    public static String getHeader(LookaheadLineReader source, MatrixParseSettings settings) throws IOException {
        String header = "";
        while ((long)(header.length() + source.peekLine().length() + 1) <= settings.headerBytes) {
            header = header + source.readLine() + "\n";
        }
        long endOfHeaderBytes = settings.headerBytes - (long)header.length();
        if (endOfHeaderBytes > 0L) {
            header = header + source.read((int)endOfHeaderBytes);
        }
        return header;
    }

    public static void parseAwayHeader(LookaheadLineReader source, MatrixParseSettings settings) throws IOException {
        TableColumnProvider.getHeader(source, settings);
    }

    public static String[] tokeniseRow(String row) {
        if (row == null) {
            return new String[0];
        }
        Object[] result = ROW_TOKENISER_REGEX.split(row);
        if (row.endsWith("\t")) {
            int eatenColumns = 0;
            for (int i = row.length() - 1; i >= 0 && '\t' == row.charAt(i); --i) {
                ++eatenColumns;
            }
            Object[] fullResult = new String[result.length + eatenColumns];
            System.arraycopy(result, 0, fullResult, 0, result.length);
            Arrays.fill(fullResult, result.length, fullResult.length, "");
            result = fullResult;
        }
        return result;
    }

    public static class TableColumn
    extends BasicFeature {
        private MatrixParseSettings settings;
        LinkedList<Integer> indexCollector = new LinkedList();
        LinkedList<String> nameCollector = new LinkedList();

        public TableColumn(String namePostfix, DataBean bean, FeatureProvider factory) throws IOException, MicroarrayException {
            super(bean, factory);
            this.settings = TableColumnProvider.inferSettings(bean);
            int c = 0;
            for (Column column : this.settings.columns.values()) {
                String[] queryParts;
                boolean match = false;
                match = namePostfix.contains("*") ? (queryParts = namePostfix.split("\\*")).length == 0 || column.name.startsWith(queryParts[0]) : column.name.equals(namePostfix);
                if (match) {
                    this.indexCollector.add(c);
                    this.nameCollector.add(column.name);
                    logger.debug((Object)("created column feature for column " + column.name + " (index " + c + ")"));
                }
                ++c;
            }
        }

        @Override
        public Iterable<Float> asFloats() throws MicroarrayException {
            if (this.indexCollector.size() != 1) {
                return null;
            }
            return new TableColumnIterable<Float>(this.getDataBean(), this.settings, this.indexCollector, this.nameCollector.getFirst(), true);
        }

        @Override
        public Iterable<String> asStrings() throws MicroarrayException {
            if (this.indexCollector.size() != 1) {
                return null;
            }
            return new TableColumnIterable<String>(this.getDataBean(), this.settings, this.indexCollector, this.nameCollector.getFirst(), false);
        }

        @Override
        public Table asTable() throws MicroarrayException {
            if (this.indexCollector.isEmpty()) {
                return null;
            }
            return new DynamicallyParsedTable(this.getDataBean(), this.settings, this.indexCollector);
        }
    }

    public static class MatrixParseSettings {
        long headerBytes = 0L;
        String footerStarter = null;
        boolean hasColumnNames = true;
        LinkedHashMap<String, Column> columns = new LinkedHashMap();
    }

    public static class TableColumnIterator<T>
    implements Iterator<T> {
        private DynamicallyParsedTable table;
        private boolean convertToFloats;
        private boolean isValidRow;
        private String columnName;

        public TableColumnIterator(DynamicallyParsedTable table, String columnName, boolean convertToFloats) {
            try {
                this.table = table;
                this.columnName = columnName;
                this.convertToFloats = convertToFloats;
                this.nextRow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.isValidRow;
        }

        @Override
        public T next() {
            Object value = this.convertToFloats ? new Float(this.table.getFloatValue(this.columnName)) : this.table.getStringValue(this.columnName);
            this.nextRow();
            return (T)value;
        }

        private void nextRow() {
            this.isValidRow = this.table.nextRow();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TableColumnIterable<T>
    implements Iterable<T> {
        private boolean convertToFloats;
        private String columnName;
        private MatrixParseSettings settings;
        private DataBean dataBean;
        private LinkedList<Integer> columnIndex;

        public TableColumnIterable(DataBean dataBean, MatrixParseSettings settings, LinkedList<Integer> columnIndex, String columnName, boolean convertToFloats) {
            this.dataBean = dataBean;
            this.settings = settings;
            this.columnIndex = columnIndex;
            this.columnName = columnName;
            this.convertToFloats = convertToFloats;
        }

        @Override
        public Iterator<T> iterator() {
            DynamicallyParsedTable table = new DynamicallyParsedTable(this.dataBean, this.settings, this.columnIndex);
            return new TableColumnIterator(table, this.columnName, this.convertToFloats);
        }
    }

    private static class Column {
        String name;

        public Column(String name) {
            this.name = name;
        }
    }
}

