/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.table;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.features.table.TableColumnProvider;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.LookaheadLineReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class DynamicallyParsedTable
implements Table {
    private LookaheadLineReader source;
    private boolean headerParsed;
    private TableColumnProvider.MatrixParseSettings settings;
    private LinkedList<Integer> columnNumbers;
    private HashMap<String, String> values;
    private String[] columnNames;
    private DataBean bean;
    private BufferedReader reader;

    public DynamicallyParsedTable(DataBean bean, TableColumnProvider.MatrixParseSettings settings, LinkedList<Integer> columnNumbers) {
        this.bean = bean;
        this.settings = settings;
        this.columnNumbers = columnNumbers;
        this.columnNames = settings.columns.keySet().toArray(new String[0]);
        this.reset();
    }

    public void reset() {
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.bean.getContentByteStream()));
            this.source = new LookaheadLineReader(this.reader);
            this.headerParsed = false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean nextRow() {
        try {
            if (this.source.peekLine() == null || this.settings.footerStarter != null && this.source.peekLine().contains(this.settings.footerStarter) || this.headerParsed && "".equals(this.source.peekLine().trim())) {
                this.values = null;
                return false;
            }
            if (!this.headerParsed) {
                if (this.settings.headerBytes != 0L) {
                    TableColumnProvider.parseAwayHeader(this.source, this.settings);
                }
                if (this.settings.hasColumnNames) {
                    this.source.readLine();
                }
                this.headerParsed = true;
            }
            if (this.source.peekLine() == null) {
                return false;
            }
            ArrayList<String> row = this.parseRow(this.source.readLine());
            this.values = new HashMap();
            if (this.columnNumbers.size() == 0) {
                int i = 0;
                for (String string : row) {
                    this.values.put(this.columnNames[i++], string);
                }
            } else {
                for (Integer number : this.columnNumbers) {
                    this.values.put(this.columnNames[number], row.get(number));
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String preprocessExternalData(String string) {
        return string.replace("EMPTY", "NaN");
    }

    private ArrayList<String> parseRow(String row) throws MicroarrayException {
        ArrayList<String> result = new ArrayList<String>(this.settings.columns.size());
        row = this.preprocessExternalData(row);
        String[] cells = TableColumnProvider.tokeniseRow(row);
        for (int i = 0; i < this.settings.columns.values().size(); ++i) {
            String cell = i < cells.length ? cells[i] : "";
            result.add(cell);
        }
        return result;
    }

    @Override
    public String[] getColumnNames() {
        String[] colunmNameSlice = new String[this.columnNumbers.size()];
        for (int i = 0; i < this.columnNumbers.size(); ++i) {
            colunmNameSlice[i] = this.columnNames[this.columnNumbers.get(i)];
        }
        return colunmNameSlice;
    }

    @Override
    public float getFloatValue(String columnName) {
        try {
            return new Float(this.values.get(columnName)).floatValue();
        }
        catch (NumberFormatException nfe) {
            return new Float(Float.NaN).floatValue();
        }
        catch (NullPointerException ne) {
            throw new IllegalArgumentException("column name " + columnName + " was not found");
        }
    }

    @Override
    public int getIntValue(String columnName) {
        return (int)this.getFloatValue(columnName);
    }

    @Override
    public String getStringValue(String columnName) {
        return this.values.get(columnName);
    }

    @Override
    public Object getValue(String columnName) {
        try {
            return new Float(this.values.get(columnName));
        }
        catch (NumberFormatException e) {
            return this.getStringValue(columnName);
        }
    }

    @Override
    public boolean hasColumn(String columnName) {
        for (String name : this.columnNames) {
            if (!name.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public void close() {
        IOUtils.closeIfPossible(this.reader);
    }
}

