/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public class Text
extends Drawable {
    private Color textColor;
    private String text;
    private boolean emphasis = false;

    public Text(float x, float y, float z, String text, Color color) {
        this.visualisationCoords = new double[1][3];
        this.projectedCoords = new double[1][2];
        this.deviceCoords = new int[1][2];
        this.dataCoords = new double[1][3];
        this.distanceFromCamera = new double[1];
        double d = x;
        this.visualisationCoords[0][0] = d;
        this.dataCoords[0][0] = d;
        double d2 = y;
        this.visualisationCoords[0][1] = d2;
        this.dataCoords[0][1] = d2;
        double d3 = z;
        this.visualisationCoords[0][2] = d3;
        this.dataCoords[0][2] = d3;
        this.text = text;
        this.textColor = color;
    }

    public Text(float x, float y, float z, String text, Color color, boolean emphasis) {
        this(x, y, z, text, color);
        this.emphasis = emphasis;
    }

    @Override
    public void draw(Graphics g, int width, int height, CoordinateArea.PaintMode notUsed) {
        g.setColor(this.color);
        this.deviceCoords[0][0] = (int)((this.projectedCoords[0][0] + 0.5) * (double)width);
        this.deviceCoords[0][1] = (int)((this.projectedCoords[0][1] + 0.5) * (double)height);
        if (this.text != null) {
            int textWidth = 0;
            int textHeight = 10;
            int textCenterX = this.deviceCoords[0][0];
            int textCenterY = this.deviceCoords[0][1];
            int x = textCenterX < width / 2 ? textCenterX - (textWidth += SwingUtilities.computeStringWidth(g.getFontMetrics(), this.text)) : textCenterX;
            int y = textCenterY < height / 2 ? textCenterY : textCenterY + textHeight;
            g.setColor(this.textColor);
            Font origFont = g.getFont();
            if (this.emphasis) {
                g.setFont(g.getFont().deriveFont(1, 16.0f));
            }
            g.drawString(this.text, x, y);
            g.setFont(origFont);
        }
    }

    @Override
    public void setDistanceFromCamera(double[] camera, double planeDistance, double viewWindowWidth, double viewWindowHeight) {
        this.distanceFromCamera[0] = DataPoint.pointDistance(camera, this.visualisationCoords[0]);
    }
}

