/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.StatusAnimation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import net.miginfocom.swing.MigLayout;

public class TrackGroup
implements ActionListener {
    JPanel component = new JPanel();
    protected List<Track> tracks = new LinkedList<Track>();
    protected GBrowserView view;
    JPanel settingsPanel;
    JCheckBox visibleBox = new JCheckBox();
    JCheckBox showMoreBox = new JCheckBox();
    private boolean isSettingsEnabled = false;
    private JPanel trackLayer;
    private JPanel settingsLayer;
    private Track singleTrack;
    private String name;
    private boolean minimized;
    private boolean showMore;
    private StatusAnimation statusAnimation;
    private boolean settingsPanelInitialized;
    private ScrollGroup scrollGroup;

    public TrackGroup(GBrowserView view) {
        this.view = view;
        this.component.setLayout(new GridBagLayout());
        this.component.setInheritsPopupMenu(true);
        this.component.addMouseListener(this.getView());
        this.component.addMouseMotionListener(this.getView());
        this.component.addMouseWheelListener(this.getView());
        this.component.setBackground(Color.white);
        this.component.setLayout(new OverlayLayout(this.component));
        this.trackLayer = new JPanel();
        this.settingsLayer = new JPanel();
        this.trackLayer.setInheritsPopupMenu(true);
        this.settingsLayer.setInheritsPopupMenu(true);
        this.component.add(this.settingsLayer);
        this.component.add(this.trackLayer);
        this.trackLayer.setLayout((LayoutManager)new MigLayout("flowy, fillx, gap 0! 0!, insets 0"));
        this.settingsLayer.setLayout((LayoutManager)new MigLayout("gap 0! 0!, insets 0"));
        this.settingsLayer.setOpaque(false);
        this.trackLayer.setBackground(Color.white);
    }

    public TrackGroup(Track track) {
        this(track.view);
        this.singleTrack = track;
        this.addTrack(track);
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
        track.setTrackGroup(this);
        this.updateLayout();
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public GBrowserView getView() {
        return this.view;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "Track Group";
    }

    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.inferTrackGroupLayoutMode(this.tracks);
    }

    public boolean isSettingsEnabled() {
        return this.isSettingsEnabled;
    }

    public void setSettingsEnabled(boolean enabled) {
        this.isSettingsEnabled = enabled;
    }

    private JComponent initSettingsIfNecesasry() {
        if (!this.settingsPanelInitialized) {
            this.createSettingsPanel();
            this.updateButtons();
            this.settingsPanelInitialized = true;
        }
        return this.settingsPanel;
    }

    public void createSettingsPanel() {
        this.settingsLayer.setOpaque(false);
        this.visibleBox.setText(this.getName());
        Font font = this.visibleBox.getFont().deriveFont(1);
        this.visibleBox.setFont(font);
        this.visibleBox.setSelected(!this.isMinimized());
        this.visibleBox.setOpaque(false);
        this.visibleBox.addActionListener(this);
        this.showMoreBox.setText(this.getShowMoreName());
        font = this.showMoreBox.getFont().deriveFont(0);
        this.showMoreBox.setFont(font);
        this.showMoreBox.setOpaque(false);
        this.showMoreBox.addActionListener(this);
        this.settingsLayer.add(this.visibleBox);
        this.settingsLayer.add((Component)this.getStatusAnimation(), "wrap");
        this.settingsLayer.add(this.showMoreBox);
    }

    public String getShowMoreName() {
        return "Show all";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.visibleBox) {
            this.setMinimzed(!this.visibleBox.isSelected());
        }
        if (e.getSource() == this.showMoreBox) {
            this.showMore(this.showMoreBox.isSelected());
        }
    }

    private void updateButtons() {
        boolean showMore = this.isShowMorePossible();
        this.showMoreBox.setVisible(showMore);
    }

    public boolean isShowMorePossible() {
        boolean showMore = false;
        for (Track track : this.tracks) {
            if (!track.isVisible() || !track.isSuitableViewLength() || !track.isShowMoreCapable()) continue;
            showMore = true;
            break;
        }
        return showMore;
    }

    protected void setMinimzed(boolean minimized) {
        this.minimized = minimized;
        this.addTracks();
        this.updateButtons();
        this.view.reloadData();
    }

    public void addTracks() {
        this.tracks.clear();
        if (!this.isMinimized()) {
            this.addTrack(this.singleTrack);
        }
    }

    protected void showMore(boolean showMore) {
        this.showMore = showMore;
        this.addTracks();
        this.updateButtons();
        this.view.reloadData();
    }

    public void updateLayout() {
        this.trackLayer.removeAll();
        if (this.isSettingsEnabled()) {
            this.initSettingsIfNecesasry();
        } else {
            this.settingsLayer.removeAll();
            this.settingsPanelInitialized = false;
        }
        for (Track track : this.tracks) {
            if (!track.isVisible() || !track.isSuitableViewLength()) continue;
            JComponent trackComponent = track.getComponent();
            LayoutTool.LayoutMode mode = track.getLayoutMode();
            if (LayoutTool.LayoutMode.FILL == mode) {
                this.trackLayer.add((Component)trackComponent, "grow");
                continue;
            }
            this.trackLayer.add((Component)trackComponent, "growx");
        }
        this.trackLayer.revalidate();
        this.updateButtons();
    }

    public JComponent getComponent() {
        return this.component;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public boolean isShowMore() {
        return this.showMore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StatusAnimation getStatusAnimation() {
        if (this.statusAnimation == null) {
            this.statusAnimation = new StatusAnimation(this.view.getQueueManager(), this);
        }
        return this.statusAnimation;
    }

    public void initializeListener() {
        this.getStatusAnimation().initilizeListeners();
        for (Track track : this.tracks) {
            track.initializeListener();
        }
    }

    public ScrollGroup getScrollGroup() {
        return this.scrollGroup;
    }

    public void setScrollGroup(ScrollGroup scrollGroup) {
        this.scrollGroup = scrollGroup;
    }
}

