/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.IOException;
import java.net.URISyntaxException;

public class RandomAccessLineDataSource
extends DataSource {
    private RandomAccessLineReader lineReader;

    public RandomAccessLineDataSource(DataUrl dataUrl) throws URISyntaxException, IOException {
        super(dataUrl);
        this.lineReader = new RandomAccessLineReader(dataUrl);
    }

    public boolean setLineReaderPosition(long position) throws IOException, GBrowserException {
        return this.lineReader.setPosition(position);
    }

    public String getNextLine() throws IOException {
        return this.lineReader.readLine();
    }

    public String getLastLine() throws IOException, GBrowserException {
        String line;
        long maxRowLength = 1024L;
        while ((line = this.getLastLine(maxRowLength)) == null) {
            maxRowLength *= 2L;
        }
        return line;
    }

    private String getLastLine(long maxRowLength) throws IOException, GBrowserException {
        String line;
        this.setLineReaderPosition(this.length() - maxRowLength);
        String lastLine = null;
        String lineBeforeLast = null;
        while ((line = this.lineReader.readLine()) != null) {
            lineBeforeLast = lastLine;
            lastLine = line;
        }
        if (lineBeforeLast != null) {
            return lastLine;
        }
        return null;
    }

    public void close() {
        this.lineReader.close();
    }

    public long length() throws IOException {
        return this.lineReader.length();
    }
}

