/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLine;
import java.util.Iterator;
import java.util.LinkedList;

public class CnaLineParser
extends AbstractTsvLineParser {
    private int gainColumn = -1;
    private int lossColumn = -1;
    private LinkedList<Integer> flagColumns;
    private LinkedList<Integer> logRatioColumns;
    private LinkedList<String> sampleNames;

    @Override
    public boolean setLine(String line) {
        if (line.startsWith(this.getHeaderStart())) {
            this.parseHeader(line);
            this.values = null;
            return false;
        }
        this.values = line.split("\t");
        return true;
    }

    private void parseHeader(String line) {
        this.flagColumns = new LinkedList();
        this.sampleNames = new LinkedList();
        this.logRatioColumns = new LinkedList();
        String[] cols = line.split("\t");
        for (int i = Column.END.ordinal() + 1; i < cols.length; ++i) {
            String title = cols[i - 1];
            if (title.startsWith("flag.")) {
                this.flagColumns.add(i);
                continue;
            }
            if (title.startsWith("loss.freq")) {
                this.lossColumn = i;
                continue;
            }
            if (title.startsWith("gain.freq")) {
                this.gainColumn = i;
                continue;
            }
            if (!title.startsWith("segmented.")) continue;
            this.logRatioColumns.add(i);
            this.sampleNames.add(title.replace("segmented.", ""));
        }
    }

    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(Column.START.ordinal());
            long end = this.getLong(Column.END.ordinal());
            Chromosome chr = new Chromosome(this.getString(Column.CHROMOSOME.ordinal()));
            return new Region(start, end, chr);
        }
        return null;
    }

    public LinkedList<String> getSampleNames() {
        return this.sampleNames;
    }

    public LinkedList<Float> getFlagValues() {
        LinkedList<Float> flagValues = new LinkedList<Float>();
        Iterator i$ = this.flagColumns.iterator();
        while (i$.hasNext()) {
            int col = (Integer)i$.next();
            flagValues.add(this.getFloat(col));
        }
        return flagValues;
    }

    public LinkedList<Float> getLogRatioValues() {
        LinkedList<Float> logRatioValues = new LinkedList<Float>();
        Iterator i$ = this.logRatioColumns.iterator();
        while (i$.hasNext()) {
            int col = (Integer)i$.next();
            logRatioValues.add(this.getFloat(col));
        }
        return logRatioValues;
    }

    public Float getLossFreq() {
        if (this.lossColumn != -1) {
            return this.getFloat(this.lossColumn);
        }
        return null;
    }

    public Float getGainFreq() {
        if (this.gainColumn != -1) {
            return this.getFloat(this.gainColumn);
        }
        return null;
    }

    @Override
    public String getHeaderStart() {
        return "chromosome\tstart\tend";
    }

    @Override
    public FileLine getFileLine() {
        return null;
    }

    public static enum Column {
        ROWNAME("row name"),
        CHROMOSOME("chromosome"),
        START("start"),
        END("end");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

