/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CigarItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.CigarElement;

public class Cigar {
    private List<CigarItem> cigarItems = new ArrayList<CigarItem>();
    private LinkedList<ReadPart> visibleElements = null;
    private LinkedList<ReadPart> processedElements = null;
    private Feature read;
    private net.sf.samtools.Cigar samCigar;

    public Cigar(Feature read, List<CigarItem> cigarItems) {
        this.read = read;
        this.cigarItems = cigarItems;
    }

    public Cigar(Feature read, net.sf.samtools.Cigar samCigar) {
        this.read = read;
        this.samCigar = samCigar;
        for (CigarElement picardElement : samCigar.getCigarElements()) {
            this.cigarItems.add(new CigarItem(picardElement));
        }
    }

    public void addElement(CigarItem e) {
    }

    @Deprecated
    public long getReferenceIndex(long seqIndex) {
        long seqCounter = 0L;
        long refCounter = 0L;
        for (CigarItem element : this.cigarItems) {
            if (element.getType().equals("M")) {
                seqCounter += element.getLength();
                refCounter += element.getLength();
            } else if (element.getType().equals("S")) {
                seqCounter += element.getLength();
            } else if (element.getType().equals("D") || element.getType().equals("N") || element.getType().equals("H")) {
                refCounter += element.getLength();
            } else if (element.getType().equals("I")) {
                seqCounter += element.getLength();
            } else if (element.getType().equals("P")) {
                // empty if block
            }
            if (seqCounter <= seqIndex) continue;
            if (element.getType().equals("I")) {
                return -1L;
            }
            if (element.getType().equals("S")) {
                return -1L;
            }
            return seqIndex + refCounter - seqCounter;
        }
        return -1L;
    }

    public String toString() {
        return "Cigar";
    }

    public static List<ReadPart> splitElements(Feature read) {
        Cigar cigar = (Cigar)read.values.get((Object)DataType.CIGAR);
        if (cigar == null) {
            return Arrays.asList(new ReadPart(read));
        }
        return cigar.getElements();
    }

    public static List<Feature> splitRead(Feature read, Collection<CigarItem.CigarItemType> splitters) {
        Cigar cigar = (Cigar)read.values.get((Object)DataType.CIGAR);
        if (cigar == null) {
            return Arrays.asList(read);
        }
        return cigar.splitReadWithCigar(read, splitters);
    }

    private List<Feature> splitReadWithCigar(Feature read, Collection<CigarItem.CigarItemType> splitters) {
        LinkedList<Feature> splittedReads = new LinkedList<Feature>();
        long refCoord = read.region.start.bp;
        long seqCoord = 0L;
        String seq = (String)read.values.get((Object)DataType.SEQUENCE);
        String combinedSeq = "";
        LinkedList<CigarItem> combinedCigar = new LinkedList<CigarItem>();
        Region region = new Region(-1L, -1L, read.region.start.chr);
        for (CigarItem cigarItem : this.cigarItems) {
            String subSeq = "";
            if (cigarItem.consumesReadBases()) {
                subSeq = seq.substring((int)seqCoord, (int)(seqCoord + cigarItem.getLength()));
            }
            if (!splitters.contains((Object)cigarItem.getCigarItemType())) {
                combinedSeq = combinedSeq + subSeq;
                combinedCigar.add(cigarItem);
                if (region.start.bp == -1L) {
                    region.start.bp = refCoord;
                }
                region.end.bp = refCoord + cigarItem.getLength();
            } else {
                LinkedHashMap values = (LinkedHashMap)read.values.clone();
                Feature splittedRead = new Feature(region, values);
                values.put(DataType.CIGAR, new Cigar(splittedRead, combinedCigar));
                values.put(DataType.SEQUENCE, combinedSeq);
                splittedReads.add(splittedRead);
                combinedCigar = new LinkedList();
                combinedSeq = "";
                region = new Region(-1L, -1L, read.region.start.chr);
            }
            if (cigarItem.consumesReferenceBases()) {
                refCoord += cigarItem.getLength();
            }
            if (!cigarItem.consumesReadBases()) continue;
            seqCoord += cigarItem.getLength();
        }
        LinkedHashMap values = (LinkedHashMap)read.values.clone();
        Feature splittedRead = new Feature(region, values);
        values.put(DataType.CIGAR, new Cigar(splittedRead, combinedCigar));
        values.put(DataType.SEQUENCE, combinedSeq);
        splittedReads.add(splittedRead);
        return splittedReads;
    }

    private List<ReadPart> getElements() {
        if (this.processedElements == null) {
            this.processedElements = new LinkedList();
            long refCoord = this.read.region.start.bp;
            long seqCoord = 0L;
            String seq = (String)this.read.values.get((Object)DataType.SEQUENCE);
            for (CigarItem cigarItem : this.cigarItems) {
                String subSeq = null;
                if (cigarItem.consumesReadBases()) {
                    subSeq = seq.substring((int)seqCoord, (int)(seqCoord + cigarItem.getLength()));
                }
                ReadPart region = new ReadPart(refCoord, refCoord + cigarItem.getLength(), this.read.region.start.chr, this.read, subSeq);
                region.setCigarItem(cigarItem);
                this.processedElements.add(region);
                if (cigarItem.consumesReferenceBases()) {
                    refCoord += cigarItem.getLength();
                }
                if (!cigarItem.consumesReadBases()) continue;
                seqCoord += cigarItem.getLength();
            }
        }
        return this.processedElements;
    }

    public String toInfoString() {
        String str = "";
        if (this.samCigar != null) {
            str = this.samCigar.toString();
        } else {
            for (CigarItem item : this.cigarItems) {
                str = str + item.getLength() + item.getType();
            }
        }
        return "Cigar: " + str;
    }
}

