/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.BrowserSelectionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserLegend;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.SelectionPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.AnnotationTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SampleTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import fi.csc.microarray.util.LinkUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXHyperlink;

public class GBrowserSettings
implements ActionListener,
RegionListener {
    private static final long DEFAULT_VIEWSIZE = 100000L;
    private static final long DEFAULT_LOCATION = 1000000L;
    private Long lastViewsize;
    private boolean initialised;
    private JPanel paramPanel;
    private JPanel settingsPanel = new JPanel();
    private JPanel genomePanel;
    private JPanel locationPanel;
    private JPanel optionsPanel;
    private JPanel linksPanel;
    private JButton goButton = new JButton("Go");
    private JLabel locationLabel = new JLabel("Location (gene or position)");
    private JTextField locationField = new JTextField();
    private JLabel viewsizeLabel = new JLabel("View size");
    private JTextField viewsizeField = new JTextField();
    private JLabel chrLabel = new JLabel("Chromosome");
    private JComboBox<Chromosome> chrBox;
    private JComboBox<AnnotationManager.Genome> genomeBox;
    private JLabel coverageScaleLabel = new JLabel("Coverage scale");
    private JComboBox<GBrowserPlot.ReadScale> coverageScaleBox;
    private JLabel coverageTypeLabel = new JLabel("Coverage type");
    private JComboBox<CoverageType> coverageTypeBox;
    private Map<String, JCheckBox> trackSwitches = new LinkedHashMap<String, JCheckBox>();
    private JXHyperlink ensemblLink;
    private JXHyperlink ucscLink;
    private GBrowser browser;
    private Long lastLocation;
    private JCheckBox cacheBox;
    private JTabbedPane tabPane;
    private GBrowserLegend legend;
    private SelectionPanel selectionPanel;
    volatile boolean failed = false;

    public void initialise(GBrowser browser) throws Exception {
        this.browser = browser;
        this.trackSwitches.put("Reads", new JCheckBox("Reads", true));
        this.trackSwitches.put("highlightSNP", new JCheckBox("Highlight SNPs", true));
        this.trackSwitches.put("DensityGraphTrack", new JCheckBox("Density graph", false));
        this.trackSwitches.put("RepeatMaskerTrack", new JCheckBox("Low complexity regions", false));
    }

    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new GridBagLayout());
            JPanel settings = this.createSettingsPanel();
            JScrollPane settingsScrollPane = new JScrollPane(settings);
            settingsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            settingsScrollPane.setHorizontalScrollBarPolicy(31);
            this.legend = new GBrowserLegend(this.browser);
            this.selectionPanel = new SelectionPanel(this.browser.getSelectionManager());
            this.tabPane = new JTabbedPane();
            this.tabPane.addTab("Settings", settingsScrollPane);
            this.tabPane.addTab("Selected", this.selectionPanel);
            this.tabPane.addTab("Legend", this.legend);
            this.browser.getSelectionManager().addSelectionListener(new BrowserSelectionListener(){

                @Override
                public void selectionChanged(DataUrl data, Selectable selectable, Object source) {
                    if (selectable != null) {
                        GBrowserSettings.this.tabPane.setSelectedComponent(GBrowserSettings.this.selectionPanel);
                    }
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.anchor = 18;
            c.fill = 1;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.insets.set(5, 0, 0, 0);
            this.paramPanel.add((Component)this.tabPane, c);
        }
        return this.paramPanel;
    }

    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel(new GridBagLayout());
            this.optionsPanel.setBorder(GBrowserSettings.createSettingsPanelSubPanelBorder("Options"));
            GridBagConstraints oc = new GridBagConstraints();
            oc.gridy = 0;
            oc.gridx = 0;
            oc.anchor = 19;
            oc.fill = 1;
            oc.weighty = 1.0;
            oc.weightx = 1.0;
            JPanel menu = new JPanel(new GridBagLayout());
            menu.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane menuScrollPane = new JScrollPane(menu);
            menuScrollPane.setHorizontalScrollBarPolicy(31);
            menuScrollPane.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints c = new GridBagConstraints();
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.anchor = 19;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            this.setTrackSwitchesEnabled(false);
            for (JCheckBox trackSwitch : this.trackSwitches.values()) {
                trackSwitch.addActionListener(this);
                menu.add((Component)trackSwitch, c);
                ++c.gridy;
            }
            this.coverageTypeLabel.setEnabled(false);
            c.insets.set(10, 0, 0, 0);
            menu.add((Component)this.coverageTypeLabel, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.coverageTypeBox = new JComboBox<CoverageType>(new CoverageType[]{CoverageType.NONE, CoverageType.TOTAL, CoverageType.STRAND});
            this.coverageTypeBox.setSelectedItem((Object)CoverageType.TOTAL);
            this.coverageTypeBox.setEnabled(false);
            this.coverageTypeBox.addActionListener(this);
            menu.add(this.coverageTypeBox, c);
            ++c.gridy;
            this.coverageScaleLabel.setEnabled(false);
            c.insets.set(10, 0, 0, 0);
            menu.add((Component)this.coverageScaleLabel, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.coverageScaleBox = new JComboBox<GBrowserPlot.ReadScale>(GBrowserPlot.ReadScale.values());
            this.coverageScaleBox.setSelectedItem((Object)GBrowserPlot.ReadScale.SMALL);
            this.coverageScaleBox.setEnabled(false);
            this.coverageScaleBox.addActionListener(this);
            menu.add(this.coverageScaleBox, c);
            this.optionsPanel.add((Component)menu, oc);
        }
        return this.optionsPanel;
    }

    private JPanel getExternalLinkPanel() {
        if (this.linksPanel == null) {
            this.linksPanel = new JPanel(new GridBagLayout());
            this.linksPanel.setBorder(GBrowserSettings.createSettingsPanelSubPanelBorder("External links"));
            this.ensemblLink = LinkUtil.createLink("Ensembl", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GBrowserSettings.this.browser.openExternalBrowser(GBrowserSettings.this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL));
                }
            });
            this.ucscLink = LinkUtil.createLink("UCSC", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GBrowserSettings.this.browser.openExternalBrowser(GBrowserSettings.this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.UCSC_BROWSER_URL));
                }
            });
            this.ensemblLink.setEnabled(false);
            this.ucscLink.setEnabled(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 0.0;
            c.weighty = 0.0;
            LinkedList<JXHyperlink> importLinks = new LinkedList<JXHyperlink>();
            importLinks.add(this.ensemblLink);
            importLinks.add(this.ucscLink);
            int MAX_ROW_CHARS = 33;
            LinkUtil.addLinks("View this region in *** or *** genome browser.", importLinks, null, c, this.linksPanel, 33, null);
            JPanel bottomPanel = new JPanel();
            JPanel rightPanel = new JPanel();
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.fill = 3;
            c.gridx = 1;
            ++c.gridy;
            this.linksPanel.add((Component)bottomPanel, c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 1;
            this.linksPanel.add((Component)rightPanel, c);
        }
        return this.linksPanel;
    }

    private void setExternalLinksEnabled() {
        this.ensemblLink.setEnabled(this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL).length() > 0);
        this.ucscLink.setEnabled(this.browser.getExternalLinkUrl(AnnotationManager.AnnotationType.UCSC_BROWSER_URL).length() > 0);
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets.set(0, 5, 15, 5);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.settingsPanel.add((Component)this.getGenomePanel(), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.getLocationPanel(), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.getOptionsPanel(), c);
        ++c.gridy;
        c.insets.set(0, 5, 5, 5);
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)this.getExternalLinkPanel(), c);
        return this.settingsPanel;
    }

    private JPanel getGenomePanel() {
        if (this.genomePanel == null) {
            this.genomePanel = new JPanel(new GridBagLayout());
            this.genomePanel.setBorder(GBrowserSettings.createSettingsPanelSubPanelBorder("Genome"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.insets.set(5, 0, 5, 0);
            c.anchor = 18;
            c.fill = 2;
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridx = 0;
            this.genomeBox = new JComboBox();
            List<AnnotationManager.Genome> genomes = this.browser.getAnnotationManager().getGenomes();
            for (AnnotationManager.Genome genome : genomes) {
                this.genomeBox.addItem(genome);
            }
            this.genomeBox.setSelectedItem(null);
            this.genomeBox.addActionListener(this);
            this.genomePanel.add(this.genomeBox, c);
            ++c.gridy;
        }
        return this.genomePanel;
    }

    private JPanel getLocationPanel() {
        if (this.locationPanel == null) {
            this.locationPanel = new JPanel(new GridBagLayout());
            this.locationPanel.setBorder(GBrowserSettings.createSettingsPanelSubPanelBorder("Location"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.anchor = 18;
            c.fill = 2;
            c.weighty = 0.0;
            c.weightx = 1.0;
            this.chrLabel.setEnabled(false);
            this.locationPanel.add((Component)this.chrLabel, c);
            ++c.gridy;
            this.chrBox = new JComboBox();
            this.chrBox.setEnabled(false);
            c.insets.set(0, 0, 10, 0);
            this.locationPanel.add(this.chrBox, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.locationLabel.setEnabled(false);
            this.locationPanel.add((Component)this.locationLabel, c);
            this.locationField.setEnabled(false);
            this.locationField.addActionListener(this);
            ++c.gridy;
            c.insets.set(0, 0, 10, 0);
            this.locationPanel.add((Component)this.locationField, c);
            c.gridx = 0;
            c.gridwidth = 5;
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.viewsizeLabel.setEnabled(false);
            this.locationPanel.add((Component)this.viewsizeLabel, c);
            c.gridwidth = 4;
            ++c.gridy;
            c.insets.set(0, 0, 10, 0);
            this.viewsizeField.setEnabled(false);
            this.viewsizeField.setEditable(false);
            this.locationPanel.add((Component)this.viewsizeField, c);
            ++c.gridy;
            c.fill = 2;
            c.anchor = 10;
            this.goButton.setEnabled(false);
            this.goButton.addActionListener(this);
            this.locationPanel.add((Component)this.goButton, c);
        }
        return this.locationPanel;
    }

    protected void fillChromosomeBox() throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        LinkedList<Chromosome> chromosomes = this.browser.getChromosomeNames();
        for (Chromosome chromosome : chromosomes) {
            this.chrBox.addItem(chromosome);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.goButton || source == this.locationField) {
            this.genomeBox.setEnabled(false);
            if (!this.initialised) {
                this.browser.runBlockingTask("initialising genome browser", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GBrowserSettings.this.browser.showVisualisation();
                                    }
                                    catch (Exception e) {
                                        GBrowserSettings.this.browser.reportException(e);
                                        GBrowserSettings.this.failed = true;
                                    }
                                }
                            });
                            if (!GBrowserSettings.this.failed) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            GBrowserSettings.this.processLocationPanelInput();
                                            GBrowserSettings.this.setExternalLinksEnabled();
                                            GBrowserSettings.this.initialised = true;
                                        }
                                        catch (Exception e) {
                                            GBrowserSettings.this.browser.reportException(e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                this.processLocationPanelInput();
                this.setExternalLinksEnabled();
            }
        } else if (source == this.coverageScaleBox && this.initialised) {
            this.browser.updateCoverageScale();
        } else if ((this.trackSwitches.values().contains(source) || source == this.coverageTypeBox) && this.initialised) {
            this.updateVisibilityForTracks();
        } else if (source == this.genomeBox) {
            AnnotationManager.Genome genome = (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
            if (!this.browser.getAnnotationManager().hasLocalAnnotations(genome)) {
                this.browser.openDownloadAnnotationsDialog(genome);
            }
            this.goButton.setEnabled(true);
            this.chrLabel.setEnabled(true);
            this.chrBox.setEnabled(true);
            this.locationLabel.setEnabled(true);
            this.locationField.setEnabled(true);
            this.viewsizeLabel.setEnabled(true);
            this.viewsizeField.setEnabled(true);
            this.coverageTypeLabel.setEnabled(true);
            this.coverageTypeBox.setEnabled(true);
            this.coverageScaleLabel.setEnabled(true);
            this.coverageScaleBox.setEnabled(true);
            this.setTrackSwitchesEnabled(true);
        }
    }

    private void setTrackSwitchesEnabled(boolean enabled) {
        for (JCheckBox trackSwitch : this.trackSwitches.values()) {
            trackSwitch.setEnabled(enabled);
            if (!enabled || !"RepeatMaskerTrack".equals(this.trackSwitches.get(trackSwitch))) continue;
            trackSwitch.setEnabled(this.browser.getAnnotationUrl(this.getGenome(), AnnotationManager.AnnotationType.REPEAT) != null);
        }
    }

    public void setCoordinateFields(Long location, Long viewsize) {
        if (location != null) {
            this.locationField.setText(location.toString());
        }
        if (viewsize != null) {
            if (viewsize > 1000000L) {
                this.viewsizeField.setText(Math.round((float)viewsize.longValue() / 1000000.0f) + " Mb");
            } else if (viewsize > 1000L) {
                this.viewsizeField.setText(Math.round((float)viewsize.longValue() / 1000.0f) + " kb");
            } else {
                this.viewsizeField.setText(viewsize + "");
            }
        }
    }

    public void updateVisibilityForTracks() {
        for (TrackGroup trackGroup : this.browser.getPlot().getDataView().getTrackGroups()) {
            if (trackGroup instanceof AnnotationTrackGroup) {
                AnnotationTrackGroup annotations = (AnnotationTrackGroup)trackGroup;
                annotations.setRepeatVisible(this.trackSwitches.get("RepeatMaskerTrack").isSelected());
            }
            if (!(trackGroup instanceof SampleTrackGroup)) continue;
            SampleTrackGroup samples = (SampleTrackGroup)trackGroup;
            samples.setCoverageType((CoverageType)((Object)this.coverageTypeBox.getSelectedItem()));
            samples.setReadsVisible(this.trackSwitches.get("Reads").isSelected());
            samples.setHighlightSnp(this.trackSwitches.get("highlightSNP").isSelected());
            samples.setDensityGraphVisible(this.trackSwitches.get("DensityGraphTrack").isSelected());
        }
        this.browser.getPlot().getDataView().reloadData();
    }

    public String getGoButtonText() {
        return this.goButton.getText();
    }

    public GBrowserPlot.ReadScale getCoverageScale() {
        return (GBrowserPlot.ReadScale)((Object)this.coverageScaleBox.getSelectedItem());
    }

    public AnnotationManager.Genome getGenome() {
        return (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
    }

    public Chromosome getChromosome() {
        return (Chromosome)this.chrBox.getSelectedItem();
    }

    public void processLocationPanelInput() {
        if (this.locationField.getText().trim().isEmpty()) {
            this.setCoordinateFields(1000000L, null);
        }
        if (this.viewsizeField.getText().trim().isEmpty()) {
            this.setCoordinateFields(null, 100000L);
            this.lastViewsize = 100000L;
        }
        if (!this.locationField.getText().isEmpty()) {
            if (!GeneIndexActions.checkIfNumber(this.locationField.getText())) {
                this.browser.requestGeneSearch(this.locationField.getText());
                this.setCoordinateFields(this.getLocation(), this.getViewSize());
            } else {
                this.browser.setLocation(this.getChromosome(), this.getLocationStart(), this.getLocationEnd());
            }
        }
    }

    public Long getLocation() {
        try {
            return Long.parseLong(this.locationField.getText());
        }
        catch (NumberFormatException e) {
            if (this.lastLocation != null) {
                return this.lastLocation;
            }
            return 1000000L;
        }
    }

    private Long getLocationStart() {
        return this.getLocation() - this.getViewSize() / 2L;
    }

    private Long getLocationEnd() {
        return this.getLocation() + this.getViewSize() / 2L;
    }

    public Long getViewSize() {
        if (this.lastViewsize != null) {
            return this.lastViewsize;
        }
        return 100000L;
    }

    public boolean setChromosome(Chromosome chr) {
        this.chrBox.setSelectedItem(chr);
        return this.chrBox.getSelectedItem().equals(chr);
    }

    @Override
    public void regionChanged(Region bpRegion) {
        this.setCoordinateFields(bpRegion.getMid(), bpRegion.getLength());
        this.lastLocation = bpRegion.getMid();
        this.lastViewsize = bpRegion.getLength();
    }

    public static TitledBorder createSettingsPanelSubPanelBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.lightGray), title);
    }

    public void updateInterpretations() throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        this.fillChromosomeBox();
    }

    public void updateTracks() {
        this.updateVisibilityForTracks();
    }

    public static enum CoverageType {
        NONE("none"),
        TOTAL("total"),
        STRAND("strand-specific");

        String name;

        private CoverageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getId() {
            return "coverage type " + this.toString();
        }
    }
}

