/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.OverviewHorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.SelectionManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.util.ImageExportUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;

public class GBrowserPlot
implements ActionListener,
Printable {
    JPanel component = new JPanel(){};
    private List<GBrowserView> views = new LinkedList<GBrowserView>();
    private GBrowserView dataView = null;
    private OverviewHorizontalView overviewView = null;
    private ReadScale readScale = ReadScale.AUTO;
    private JMenuItem saveMenuItem;
    private JMenuItem printMenuItem;
    private GBrowser browser;
    private JFileChooser saveFileChooser;

    public GBrowserPlot(GBrowser browser, boolean horizontal, Region defaultLocation) {
        this.browser = browser;
        this.overviewView = new OverviewHorizontalView(this);
        this.dataView = new HorizontalView(this, true, true, false);
        this.views.add(this.overviewView);
        this.views.add(this.dataView);
        this.component.setLayout((LayoutManager)new MigLayout("flowy, fillx, gap 0! 0!, insets 0"));
        this.component.add((Component)this.overviewView.getComponent(), "growx");
        this.component.add((Component)this.dataView.getComponent(), "grow");
        this.dataView.addRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                GBrowserPlot.this.overviewView.setBpRegion(new RegionDouble(-5.0E7, 3.0E8, bpRegion.start.chr));
                ((GBrowserPlot)GBrowserPlot.this).overviewView.highlight = bpRegion;
            }
        });
        this.overviewView.addOverviewRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                GBrowserPlot.this.dataView.setBpRegion(new RegionDouble(bpRegion));
            }
        });
        this.component.setCursor(new Cursor(12));
        JPopupMenu popup = new JPopupMenu();
        this.saveMenuItem = new JMenuItem("Save as...");
        this.printMenuItem = new JMenuItem("Print...");
        this.saveMenuItem.addActionListener(this);
        this.printMenuItem.addActionListener(this);
        popup.add(this.saveMenuItem);
        popup.add(this.printMenuItem);
        this.component.setComponentPopupMenu(popup);
        this.dataView.setBpRegion(new RegionDouble(defaultLocation));
    }

    public GBrowserView getDataView() {
        return this.dataView;
    }

    public GBrowserView getOverviewView() {
        return this.overviewView;
    }

    public void start(String chromosome, Double chromosomeSizeBp, Long position, Long length) {
        this.overviewView.setBpRegion(new RegionDouble(0.0, chromosomeSizeBp, new Chromosome(chromosome)));
        this.moveDataBpRegion(new Chromosome(chromosome), position, length);
    }

    public void moveDataBpRegion(Chromosome moveToChr, Long moveToBp, Long length) {
        RegionDouble bpCoordRegion = new RegionDouble(new Double(moveToBp - length / 2L), new Double(moveToBp + length / 2L), moveToChr);
        this.dataView.setBpRegion(bpCoordRegion);
    }

    public void addDataRegionListener(RegionListener regionListener) {
        this.dataView.addRegionListener(regionListener);
    }

    public String getPlotType() {
        return "GenomeBrowser";
    }

    public void redraw() {
        for (GBrowserView view : this.views) {
            view.updateLayout();
        }
        this.component.repaint();
    }

    public Collection<GBrowserView> getViews() {
        return this.views;
    }

    public ReadScale getReadScale() {
        return this.readScale;
    }

    public void setReadScale(ReadScale readScale) {
        this.readScale = readScale;
        this.dataView.reloadData();
    }

    public void clean() {
        this.overviewView.clean();
        this.dataView.clean();
        this.dataView = null;
    }

    public void initializeDataResultListeners() {
        for (GBrowserView view : this.views) {
            for (TrackGroup group : view.getTrackGroups()) {
                group.initializeListener();
            }
        }
    }

    public void updateData() {
        for (GBrowserView view : this.views) {
            view.fireDataRequests();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.saveMenuItem) {
            try {
                this.saveFileChooser = ImageExportUtils.saveComponent(this.component, this.saveFileChooser);
                this.redraw();
            }
            catch (IOException e) {
                this.browser.reportException(e);
            }
        }
        if (event.getSource() == this.printMenuItem) {
            try {
                ImageExportUtils.printComponent(this);
                this.redraw();
            }
            catch (PrinterException e) {
                this.browser.reportException(e);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        return ImageExportUtils.printComponent(g, pf, page, this.component);
    }

    public Component getComponent() {
        return this.component;
    }

    public SelectionManager getSelectionManager() {
        return this.browser.getSelectionManager();
    }

    public GBrowser getBrowser() {
        return this.browser;
    }

    public static enum ReadScale {
        XS("10", 10),
        SMALL("50", 50),
        MEDIUM("100", 100),
        MEDIUM2("250", 250),
        LARGE("500", 500),
        XL("1000", 1000),
        XXL("5000", 5000),
        XXXL("10000", 10000),
        AUTO("Automatic", 0);

        private String name;
        public Integer numReads;

        private ReadScale(String name, Integer numReads) {
            this.name = name;
            this.numReads = numReads;
        }

        public String toString() {
            return this.name;
        }
    }
}

