/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class BamToDetailsConversion
extends DataThread {
    private static final int RESULT_CHUNK_SIZE = 5000;
    private BamDataSource dataSource;

    public BamToDetailsConversion(BamDataSource file, GBrowser browser) {
        super(browser, file);
        this.dataSource = file;
    }

    @Override
    public void clean() {
        this.dataSource.close();
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        CloseableIterator<SAMRecord> iterator = this.dataSource.query(request.start.chr, request.start.bp.intValue(), request.end.bp.intValue());
        while (iterator.hasNext()) {
            LinkedList<Feature> responseList = new LinkedList<Feature>();
            for (int c = 0; c < 5000 && iterator.hasNext(); ++c) {
                SAMRecord record = (SAMRecord)iterator.next();
                Region recordRegion = new Region(Long.valueOf(record.getAlignmentStart()), Long.valueOf(record.getAlignmentEnd()), request.start.chr);
                LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
                Feature read = new Feature(recordRegion, values);
                if (request.getRequestedContents().contains((Object)DataType.ID)) {
                    values.put(DataType.ID, record.getReadName());
                }
                if (request.getRequestedContents().contains((Object)DataType.STRAND)) {
                    values.put(DataType.STRAND, (Object)(record.getReadNegativeStrandFlag() ? Strand.REVERSE : Strand.FORWARD));
                }
                if (request.getRequestedContents().contains((Object)DataType.QUALITY)) {
                    values.put(DataType.QUALITY, record.getBaseQualityString());
                }
                if (request.getRequestedContents().contains((Object)DataType.CIGAR)) {
                    Cigar cigar = new Cigar(read, record.getCigar());
                    values.put(DataType.CIGAR, cigar);
                }
                if (request.getRequestedContents().contains((Object)DataType.SEQUENCE)) {
                    String seq = record.getReadString();
                    values.put(DataType.SEQUENCE, seq);
                }
                if (request.getRequestedContents().contains((Object)DataType.MATE_POSITION)) {
                    BpCoord mate = new BpCoord(Long.valueOf(record.getMateAlignmentStart()), new Chromosome(record.getMateReferenceName()));
                    values.put(DataType.MATE_POSITION, mate);
                }
                responseList.add(read);
            }
            super.createDataResult(new DataResult(request.getStatus(), responseList));
        }
        iterator.close();
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

