/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.constants.VisualConstants;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class GBrowserStarter {
    private static void checkData(DataUrl ... urls) throws IOException, URISyntaxException {
        boolean fileNotFoundFail = false;
        for (DataUrl dataUrl : urls) {
            File file = dataUrl.getLocalFile();
            if (file.exists()) continue;
            System.err.println("File not found: " + file);
            fileNotFoundFail = true;
        }
        if (fileNotFoundFail) {
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        String dataPath = System.getProperty("user.home") + "/example-data/";
        DataUrl BAM_DATA_FILE = new DataUrl(new File(dataPath + "GM12878.bam").toURI().toURL(), "GM12878.bam");
        DataUrl BAI_DATA_FILE = new DataUrl(new File(dataPath + "GM12878.bam.bai").toURI().toURL(), "GM12878.bam.bai");
        DataUrl BED_DATA_FILE = new DataUrl(new File(dataPath + "colors.bed").toURI().toURL(), "colors.bed");
        DataUrl VCF_DATA_FILE = new DataUrl(new File(dataPath + "var.flt.vcf").toURI().toURL(), "var.flt.vcf");
        DataUrl GTF1_DATA_FILE = new DataUrl(new File(dataPath + "cufflinks-gtf/merged-sort.gtf").toURI().toURL(), "merged-sort.gtf");
        DataUrl GTF2_DATA_FILE = new DataUrl(new File(dataPath + "Homo_sapiens.GRCh37.69-sort.gtf").toURI().toURL().toURI().toURL(), "Homo_sapiens.GRCh37.69-sort.gtf");
        DataUrl GTF3_DATA_FILE = new DataUrl(new URL("http://chipster-filebroker.csc.fi:7060/public/annotations/tmp/Homo_sapiens.GRCh37.69-sort.gtf").toURI().toURL(), "Homo_sapiens.GRCh37.66-sort.gtf");
        DataUrl CNA_DATA_FILE = new DataUrl(new File(dataPath + "cna/regions.tsv").toURI().toURL(), "regions.tsv");
        DataUrl PHENODATA_FILE = new DataUrl(new File(dataPath + "cna/phenodata.tsv").toURI().toURL(), "phenodata.tsv");
        LinkedList<Interpretation> interpretations = new LinkedList<Interpretation>();
        for (int i = 0; i < 2; ++i) {
            Interpretation reads = new Interpretation(Interpretation.TrackType.READS, BAM_DATA_FILE);
            reads.setIndexData(BAI_DATA_FILE);
            interpretations.add(reads);
        }
        interpretations.add(new Interpretation(Interpretation.TrackType.REGIONS, BED_DATA_FILE));
        GBrowserStarter.checkData(BAM_DATA_FILE, BAI_DATA_FILE);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        BasicGBrowser browser = new BasicGBrowser();
        browser.initialise();
        JPanel parameterPanel = browser.getParameterPanel();
        JComponent component = browser.getVisualisation(interpretations);
        JSplitPane split = new JSplitPane(1, component, parameterPanel);
        split.setDividerLocation(1000);
        frame.add(split);
        frame.setSize(1280, 800);
        frame.setVisible(true);
    }

    private static class BasicGBrowser
    extends GBrowser {
        private BasicGBrowser() {
        }

        @Override
        public ImageIcon getIcon(String path) {
            return new ImageIcon(VisualConstants.class.getResource(path));
        }

        @Override
        public URL getRemoteAnnotationsUrl() throws Exception {
            return new URL("http://chipster-filebroker.csc.fi:8080/public/annotations");
        }

        @Override
        public File getLocalAnnotationDir() throws IOException {
            return new File(System.getProperty("user.home") + "/.chipster/annotations");
        }
    }
}

