/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.selection;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.selection.PointSelectionEvent;
import fi.csc.microarray.client.selection.SelectionEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.basic.BasicModule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class IntegratedSelectionManager {
    private ClientApplication client;
    private DataBean data;
    private int[] selectedRows = new int[0];
    private static IntegratedEntity pointSelection;

    public IntegratedSelectionManager(ClientApplication client, DataBean data) {
        this.client = client;
        this.data = data;
    }

    public int[] getSelectionAsRows() {
        return (int[])this.selectedRows.clone();
    }

    public IntegratedEntity getPointSelection() {
        return pointSelection;
    }

    public List<String> getSelectionAsIdentifiers() throws MicroarrayException {
        Arrays.sort(this.selectedRows);
        ArrayList<String> names = new ArrayList<String>(this.selectedRows.length);
        int i = 0;
        for (String name : this.data.queryFeatures("/identifier").asStrings()) {
            if (Arrays.binarySearch(this.selectedRows, i) >= 0) {
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    public List<String> getSelectedLines() throws Exception {
        ArrayList<String> lines = new ArrayList<String>(this.selectedRows.length + 1);
        try (BufferedReader original = new BufferedReader(new InputStreamReader(this.data.getContentByteStream()));){
            String line;
            String header = this.data.queryFeatures("/header").asString();
            for (long l = 0L; l < (long)header.length(); ++l) {
                original.read();
            }
            boolean hasColumnNames = this.data.getTypeTags().contains(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
            if (hasColumnNames) {
                lines.add(original.readLine());
            }
            Arrays.sort(this.selectedRows);
            int i = 0;
            while ((line = original.readLine()) != null) {
                if (Arrays.binarySearch(this.selectedRows, i) >= 0) {
                    lines.add(line);
                }
                ++i;
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static DataBean createDataset(Iterable<String> lines, DataBean ... sources) throws Exception {
        DataManager dataManager = Session.getSession().getApplication().getDataManager();
        DataBean primarySource = sources[0];
        String ext = FilenameUtils.getExtension((String)primarySource.getName());
        if (ext == null || ext == "") {
            ext = "tsv";
        }
        DataBean newData = dataManager.createDataBean("user_edited." + ext);
        String header = primarySource.queryFeatures("/header").asString();
        OutputStream outputStream = dataManager.getContentOutputStreamAndLockDataBean(newData);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.append(header);
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        dataManager.closeContentOutputStreamAndUnlockDataBean(newData, outputStream);
        newData.setOperationRecord(new OperationRecord(new Operation(OperationDefinition.CREATE_DEFINITION, new DataBean[]{newData})));
        newData.setContentType(primarySource.getContentType());
        for (DataBean data : sources) {
            newData.addLink(DataBean.Link.MODIFICATION, data);
        }
        primarySource.getParent().addChild(newData);
        return newData;
    }

    public void setSelection(int[] selection, Object source) {
        this.selectedRows = (int[])selection.clone();
        this.client.fireClientEvent(new SelectionEvent(this.data, source));
    }

    public void setPointSelection(IntegratedEntity entity, Object source) {
        pointSelection = entity;
        this.client.fireClientEvent(new PointSelectionEvent(this.data, source));
    }

    public void clearAll(Object source) {
        this.selectedRows = new int[0];
    }

    public void setSelected(Set<Integer> set, Object source) {
        set.remove(null);
        int[] indexes = new int[set.size()];
        int i = 0;
        for (Integer index : set) {
            if (index == null) continue;
            indexes[i++] = index;
        }
        this.selectedRows = indexes;
        this.client.fireClientEvent(new SelectionEvent(this.data, source));
    }
}

