/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.ClientContextMenu;
import fi.csc.microarray.client.ClientFocusTraversalPolicy;
import fi.csc.microarray.client.ClientListener;
import fi.csc.microarray.client.Frames;
import fi.csc.microarray.client.HelpMapping;
import fi.csc.microarray.client.MicroarrayMenuBar;
import fi.csc.microarray.client.QuickLinkPanel;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.StatusBar;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dataimport.table.InformationDialog;
import fi.csc.microarray.client.dataview.DetailsPanel;
import fi.csc.microarray.client.dataview.GraphPanel;
import fi.csc.microarray.client.dataview.TreePanel;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.dialog.ErrorDialogUtils;
import fi.csc.microarray.client.dialog.ImportSettingsAccessory;
import fi.csc.microarray.client.dialog.SessionRestoreDialog;
import fi.csc.microarray.client.dialog.SnapshotAccessory;
import fi.csc.microarray.client.dialog.URLImportDialog;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolPanel;
import fi.csc.microarray.client.screen.ChildScreenPool;
import fi.csc.microarray.client.screen.HistoryScreen;
import fi.csc.microarray.client.screen.Screen;
import fi.csc.microarray.client.screen.ShowSourceScreen;
import fi.csc.microarray.client.screen.TaskManagerScreen;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.session.SessionLoader;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.waiting.WaitGlassPane;
import fi.csc.microarray.client.workflow.WorkflowManager;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.exception.ErrorReportAsException;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.GeneralFileFilter;
import fi.csc.microarray.util.SplashScreen;
import fi.csc.microarray.util.Strings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.Logger;

public class SwingClientApplication
extends ClientApplication {
    private static final int METADATA_FETCH_TIMEOUT_SECONDS = 15;
    private static final long SLOW_VISUALISATION_LIMIT = 5000L;
    private static final long VERY_SLOW_VISUALISATION_LIMIT = 20000L;
    private static Logger logger;
    private JFrame mainFrame = null;
    private JPanel rightSideViewChanger = null;
    private JPanel leftSideContentPane = null;
    private JSplitPane rightSplit = null;
    private JSplitPane leftSplit = null;
    private JSplitPane mainSplit = null;
    private MicroarrayMenuBar menuBar;
    private TaskManagerScreen taskManagerScreen;
    private StatusBar statusBar;
    private SimpleInternalFrame treeFrame;
    private SimpleInternalFrame graphFrame;
    private SimpleInternalFrame operationsFrame;
    private JPanel visualisationArea;
    private SimpleInternalFrame detailsFrame;
    private ChildScreenPool childScreens;
    private TreePanel tree;
    private DetailsPanel details;
    private GraphPanel graphPanel;
    private ToolPanel toolPanel;
    private VisualisationFrameManager visualisationFrameManager;
    private HistoryScreen historyScreen;
    private SplashScreen splashScreen;
    private ClientListener clientListener;
    private WaitGlassPane waitPanel = new WaitGlassPane();
    private static float fontSize;
    private JFileChooser importExportFileChooser;
    private JFileChooser sessionFileChooser;
    private JFileChooser workflowFileChooser;
    private String windowTitleJobPrefix = null;
    private String windowTitleBlockingPrefix = null;
    private static PlasticTheme theme;
    private static LookAndFeel lnf;

    public SwingClientApplication(ClientListener clientListener, AuthenticationRequestListener overridingARL, String module) throws MicroarrayException, IOException, ConfigurationLoader.IllegalConfigurationException {
        super(overridingARL);
        logger = Logger.getLogger(SwingClientApplication.class);
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.error((Object)new MicroarrayException("SwingClientApplication was created outside the Event Dispatch Thread."));
            System.exit(1);
        }
        this.clientListener = clientListener;
        this.requestedModule = module;
        this.splashScreen = new SplashScreen(VisualConstants.SPLASH_SCREEN);
        this.reportInitialisationThreadSafely("Initialising " + ApplicationConstants.TITLE, true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingClientApplication.this.initialiseApplication();
                }
                catch (Exception e) {
                    SwingClientApplication.this.reportInitalisationErrorThreadSafely(e);
                }
            }
        });
        t.start();
    }

    private void reportInitalisationErrorThreadSafely(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingClientApplication.this.showDialog("Starting Chipster failed.", "There could be a problem with the network connection, or the remote services could be down. Please see the details below for more information about the problem.\n\n", Exceptions.getStackTrace(e), DialogInfo.Severity.ERROR, false);
                SwingClientApplication.this.splashScreen.close();
                logger.error((Object)e);
            }
        });
    }

    @Override
    public void reportInitialisationThreadSafely(final String report, final boolean newline) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (newline) {
                    SwingClientApplication.this.splashScreen.writeLine(report);
                } else {
                    SwingClientApplication.this.splashScreen.write(report);
                }
            }
        });
    }

    @Override
    protected void initialiseGUIThreadSafely(final File mostRecentDeadTempDirectory) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingClientApplication.this.initialiseGUI(mostRecentDeadTempDirectory);
                }
                catch (MicroarrayException | IOException e) {
                    SwingClientApplication.this.reportInitalisationErrorThreadSafely(e);
                }
            }
        });
    }

    private void initialiseGUI(File mostRecentDeadTempDirectory) throws MicroarrayException, IOException {
        try {
            this.definitionsInitialisedLatch.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.toolModules == null) {
            throw new MicroarrayException("metadata was not received (analyser not functional?)");
        }
        this.mainFrame = new JFrame();
        this.updateWindowTitle();
        this.childScreens = new ChildScreenPool(this.mainFrame);
        Frames frames = new Frames(this.mainFrame);
        Session.getSession().setFrames(frames);
        SwingClientApplication.setPlastic3DLookAndFeel(this.mainFrame);
        this.mainFrame.setLocationByPlatform(true);
        this.taskManagerScreen = this.getTaskManagerScreen();
        this.historyScreen = new HistoryScreen();
        this.childScreens.put("History", this.historyScreen);
        this.childScreens.put("ShowSource", new ShowSourceScreen());
        this.childScreens.put("Import", new ImportScreen());
        this.childScreens.put("TaskList", this.taskManagerScreen);
        try {
            this.toolPanel = new ToolPanel(this.toolModules);
        }
        catch (SADLParser.ParseException e) {
            logger.error((Object)"SADL parse failed", (Throwable)e);
            throw new MicroarrayException(e);
        }
        this.operationsFrame = this.getOperationsFrame();
        this.visualisationFrameManager = new VisualisationFrameManager();
        this.visualisationArea = this.getVisualisationFrameManager().getFramesPanel();
        this.rightSplit = new JSplitPane(0, this.operationsFrame, this.visualisationArea);
        this.rightSplit.setDividerLocation(250);
        this.rightSplit.setResizeWeight(0.1);
        this.leftSideContentPane = new JPanel(new BorderLayout());
        this.details = new DetailsPanel(this.leftSideContentPane);
        this.leftSideContentPane.setBorder(BorderFactory.createEmptyBorder());
        this.graphPanel = new GraphPanel();
        this.treeFrame = this.getTreeFrame();
        this.graphFrame = this.getGraphFrame();
        this.leftSplit = new JSplitPane(0, this.treeFrame, this.graphFrame);
        this.leftSplit.setDividerLocation(250);
        this.leftSplit.setResizeWeight(0.1);
        this.detailsFrame = this.getDetailsFrame();
        this.leftSideContentPane.add((Component)this.leftSplit, "Center");
        this.leftSideContentPane.add((Component)this.detailsFrame, "South");
        this.rightSideViewChanger = new JPanel(new BorderLayout());
        if (this.isStandalone()) {
            this.rightSideViewChanger.add((Component)this.visualisationArea, "Center");
        } else {
            this.rightSideViewChanger.add((Component)this.rightSplit, "Center");
        }
        this.rightSideViewChanger.setBorder(BorderFactory.createEmptyBorder());
        this.mainSplit = new JSplitPane(1, this.leftSideContentPane, this.rightSideViewChanger);
        this.mainSplit.setDividerLocation(360);
        this.mainSplit.setResizeWeight(0.1);
        this.menuBar = new MicroarrayMenuBar(this);
        this.statusBar = new StatusBar(this);
        this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.mainSplit, "Center");
        this.mainFrame.getContentPane().add((Component)this.statusBar.getStatusPanel(), "South");
        this.mainFrame.setJMenuBar(this.menuBar);
        this.menuBar.updateMenuStatus();
        JRootPane rootPane = SwingUtilities.getRootPane(this.mainFrame);
        rootPane.setGlassPane(this.waitPanel);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingClientApplication.this.quit();
            }
        });
        this.mainFrame.setIconImage(VisualConstants.APPLICATION_ICON.getImage());
        this.mainFrame.pack();
        this.mainFrame.setExtendedState(6);
        this.mainFrame.setVisible(true);
        this.mainFrame.setDefaultCloseOperation(0);
        super.setEventsEnabled(true);
        this.manager.setEventsEnabled(true);
        this.splashScreen.close();
        if (this.clientListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingClientApplication.this.clientListener.onSuccessfulInitialisation();
                }
            });
        }
        this.customiseFocusTraversal();
        this.restoreDefaultView();
        this.enableKeyboardShortcuts();
        if (!this.getInitialisationWarnings().isEmpty()) {
            this.showDialog("Missing tools", "Some tools were not loaded during the startup and they will not be shown in the tool lists. This suggests that there are technical problems with the server you are connected to.", this.getInitialisationWarnings(), DialogInfo.Severity.WARNING, true);
        }
        if (mostRecentDeadTempDirectory != null) {
            File sessionFile = UserSession.findBackupFile(mostRecentDeadTempDirectory, false);
            new SessionRestoreDialog(this, sessionFile).setVisible(true);
        }
    }

    private void customiseFocusTraversal() throws MicroarrayException {
        Vector<Component> order = new Vector<Component>();
        order.addAll(this.tree.getFocusComponents());
        order.addAll(this.toolPanel.getFocusComponents());
        order.addAll(this.visualisationFrameManager.getFocusComponents());
        this.getMainFrame().setFocusTraversalPolicy(new ClientFocusTraversalPolicy(order));
    }

    public void updateWindowTitleJobCount(Integer jobCount) {
        this.windowTitleJobPrefix = jobCount > 0 ? jobCount + " tasks / " : null;
        this.updateWindowTitle();
    }

    public void updateWindowTitleBlockingState(String operation) {
        this.windowTitleBlockingPrefix = operation != null ? Strings.startWithUppercase(operation) + " / " : null;
        this.updateWindowTitle();
    }

    public void updateWindowTitle() {
        if (this.windowTitleBlockingPrefix != null) {
            this.mainFrame.setTitle(this.windowTitleBlockingPrefix + Session.getSession().getPrimaryModule().getDisplayName() + " " + ApplicationConstants.VERSION);
        } else if (this.windowTitleJobPrefix != null) {
            this.mainFrame.setTitle(this.windowTitleJobPrefix + Session.getSession().getPrimaryModule().getDisplayName() + " " + ApplicationConstants.VERSION);
        } else {
            this.mainFrame.setTitle(Session.getSession().getPrimaryModule().getDisplayName() + " " + ApplicationConstants.VERSION);
        }
    }

    public SimpleInternalFrame getOperationsFrame() {
        if (this.operationsFrame == null) {
            this.operationsFrame = new SimpleInternalFrame("Analysis tools");
            this.operationsFrame.setContent(this.toolPanel);
        }
        return this.operationsFrame;
    }

    public SimpleInternalFrame getGraphFrame() throws MicroarrayException {
        if (this.graphFrame == null) {
            this.graphFrame = new SimpleInternalFrame("Workflow", this.graphPanel.getButtonToolBar(), this.graphPanel.getScroller());
        }
        return this.graphFrame;
    }

    public SimpleInternalFrame getTreeFrame() throws MicroarrayException {
        if (this.treeFrame == null) {
            this.treeFrame = new SimpleInternalFrame("Datasets");
            CardLayout cardLayout = new CardLayout();
            JPanel cardPanel = new JPanel(cardLayout);
            QuickLinkPanel linkPanel = new QuickLinkPanel();
            this.tree = new TreePanel(this.manager.getRootFolder(), cardPanel, cardLayout);
            cardPanel.add((Component)linkPanel, "LINKS");
            cardPanel.add((Component)this.tree, "TREE");
            this.treeFrame.add(cardPanel);
            cardLayout.first(cardPanel);
            return this.treeFrame;
        }
        return this.treeFrame;
    }

    public SimpleInternalFrame getDetailsFrame() throws MicroarrayException {
        if (this.detailsFrame == null) {
            class DetailsFrame
            extends SimpleInternalFrame
            implements PropertyChangeListener {
                public DetailsFrame() {
                    super("Notes for dataset");
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt instanceof DatasetChoiceEvent) {
                        DatasetChoiceEvent dce = (DatasetChoiceEvent)evt;
                        if (dce.getNewValue() != null) {
                            this.setTitle("Notes for dataset " + dce.getNewValue());
                        } else {
                            this.setTitle("Notes for dataset");
                        }
                    }
                }
            }
            DetailsFrame detailsFrameWithListener = new DetailsFrame();
            this.addClientEventListener(detailsFrameWithListener);
            this.detailsFrame = detailsFrameWithListener;
            this.detailsFrame.add(this.details);
            return this.detailsFrame;
        }
        return this.detailsFrame;
    }

    public static void setPlastic3DLookAndFeel(Component componentTreeRoot) {
        if (theme == null) {
            theme = new CustomExperienceBlue();
            Plastic3DLookAndFeel.setPlasticTheme((PlasticTheme)theme);
        }
        if (lnf == null) {
            lnf = new Plastic3DLookAndFeel();
            try {
                UIManager.installLookAndFeel("Plastic3D", lnf.getClass().getName());
                UIManager.setLookAndFeel(lnf);
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
                logger.error((Object)Exceptions.getStackTrace(e));
            }
        }
        UIDefaults defaults = UIManager.getDefaults();
        defaults.putAll(VisualConstants.getUIDefaults());
        SwingUtilities.updateComponentTreeUI(componentTreeRoot);
    }

    public void setFontSize(float size) {
        fontSize = size;
        SwingUtilities.updateComponentTreeUI(this.mainFrame);
        this.fixFileChooserFontSize(this.importExportFileChooser);
        this.statusBar.setFontSize(fontSize);
        Iterator<Screen> iter = this.childScreens.getScreenIterator();
        while (iter.hasNext()) {
            Screen screen = iter.next();
            SwingUtilities.updateComponentTreeUI(screen.getFrame());
        }
    }

    public float getFontSize() {
        return fontSize;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public DataFolder initializeFolderForImport(String folderName) {
        DataFolder root = this.manager.getRootFolder();
        if (folderName == null || folderName.isEmpty()) {
            logger.debug((Object)("initializing for import " + folderName + ": is null => using root"));
            return root;
        }
        if (ImportUtils.getFolderNames(false).contains(folderName)) {
            logger.debug((Object)("initializing for import " + folderName + ": exists already"));
            DataFolder folderToSelect = folderName.equals(root.getName()) ? root : root.getChildFolder(folderName);
            this.getSelectionManager().selectSingle(folderToSelect, this);
            return folderToSelect;
        }
        logger.debug((Object)("initializing for import " + folderName + ": creating new "));
        DataFolder folder = this.getDataManager().createFolder(root, folderName);
        this.getSelectionManager().selectSingle(folder, this);
        return folder;
    }

    @Override
    public void importGroup(final Collection<ImportItem> datas, final String folderName) {
        this.runBlockingTask("importing files", new Runnable(){

            @Override
            public void run() {
                DataBean lastGroupMember = null;
                try {
                    for (ImportItem item : datas) {
                        DataBean data;
                        DataFolder folder;
                        ContentType contentType;
                        block14: {
                            String dataSetName = item.getOutput().getName();
                            contentType = item.getType();
                            File dataSource = item.getInput();
                            folder = SwingClientApplication.this.initializeFolderForImport(folderName);
                            data = null;
                            if (dataSource instanceof File) {
                                data = SwingClientApplication.this.manager.createDataBean(dataSetName, dataSource);
                            } else {
                                InputStream input;
                                if (dataSource instanceof URL) {
                                    URL url = (URL)((Object)dataSource);
                                    try {
                                        input = url.openStream();
                                        SwingClientApplication.this.manager.createDataBean(dataSetName, input);
                                        break block14;
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                SwingClientApplication.this.showDialog("File not found.", null, "File not found. Check that the typed URL is pointing to a valid location", DialogInfo.Severity.ERROR, false);
                                            }
                                        });
                                        break;
                                    }
                                    catch (IOException ioe) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                SwingClientApplication.this.showDialog("Import failed.", null, "Error occured while importing data from URL", DialogInfo.Severity.ERROR, false);
                                            }
                                        });
                                        break;
                                    }
                                }
                                if (dataSource instanceof InputStream) {
                                    logger.info((Object)"loading data from a plain stream, caching can not be used!");
                                    input = (InputStream)((Object)dataSource);
                                } else {
                                    throw new IllegalArgumentException("unknown dataSource type: " + dataSource.getClass().getSimpleName());
                                }
                            }
                        }
                        if (data == null) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SwingClientApplication.this.showDialog("Importing dataset filed.", null, "Created DataBean was null.", DialogInfo.Severity.WARNING, false);
                                }
                            });
                            return;
                        }
                        data.setContentType(contentType);
                        Operation importOperation = new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{data});
                        data.setOperationRecord(new OperationRecord(importOperation));
                        folder.addChild(data);
                        if (lastGroupMember != null && ChipsterInputTypes.hasRawType(lastGroupMember) && ChipsterInputTypes.hasRawType(data)) {
                            DataBean targetData = data;
                            for (DataBean sourceData : lastGroupMember.traverseLinks(new DataBean.Link[]{DataBean.Link.GROUPING}, DataBean.Traversal.BIDIRECTIONAL)) {
                                logger.debug((Object)("Created GROUPING link between " + sourceData.getName() + " and " + targetData.getName()));
                                SwingClientApplication.this.createLink(sourceData, targetData, DataBean.Link.GROUPING);
                            }
                            SwingClientApplication.this.createLink(lastGroupMember, targetData, DataBean.Link.GROUPING);
                        }
                        lastGroupMember = data;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void showErrorDialog(String title, Exception error) {
        this.showDialog(title, null, Exceptions.getStackTrace(error), DialogInfo.Severity.ERROR, false);
    }

    public void showDialog(String title, DialogInfo.Severity severity, boolean modal) {
        this.showDialog(title, null, null, severity, modal);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
        this.showDialog(title, message, details, severity, modal, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button) {
        DialogInfo dialogInfo = new DialogInfo(severity, title, message, details);
        ChipsterDialog.showDialog(this, dialogInfo, detailsVisibility, modal, null, button);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button, boolean feedbackEnabled) {
        DialogInfo dialogInfo = new DialogInfo(severity, title, message, details);
        dialogInfo.setFeedbackVisible(feedbackEnabled);
        ChipsterDialog.showDialog(this, dialogInfo, detailsVisibility, modal, null, button);
    }

    @Override
    public File saveWorkflow() {
        try {
            JFileChooser fileChooser = this.getWorkflowFileChooser();
            int ret = fileChooser.showSaveDialog(this.getMainFrame());
            if (ret == 0) {
                File selected = fileChooser.getSelectedFile();
                File newFile = selected.getName().endsWith("bsh") ? selected : new File(selected.getCanonicalPath() + "." + "bsh");
                this.workflowManager.saveSelectedWorkflow(newFile);
                this.unsavedChanges = false;
                this.menuBar.addRecentWorkflow(newFile.getName(), Files.toUrl(newFile));
                this.menuBar.updateMenuStatus();
                return newFile;
            }
            this.menuBar.updateMenuStatus();
        }
        catch (IOException e) {
            this.reportException(e);
        }
        return null;
    }

    @Override
    public void runWorkflow(URL workflowScript) {
        this.runWorkflow(workflowScript, null);
    }

    @Override
    public void runWorkflow(URL workflowScript, AtEndListener atEndListener) {
        this.workflowManager.runScript(workflowScript, atEndListener);
    }

    @Override
    public File openWorkflow() {
        try {
            JFileChooser fileChooser = this.getWorkflowFileChooser();
            int ret = fileChooser.showOpenDialog(this.getMainFrame());
            if (ret == 0) {
                this.runWorkflow(fileChooser.getSelectedFile().toURI().toURL());
                this.menuBar.updateMenuStatus();
                return fileChooser.getSelectedFile();
            }
            this.menuBar.updateMenuStatus();
            return null;
        }
        catch (MalformedURLException e) {
            this.reportException(e);
            return null;
        }
    }

    @Override
    public void showHistoryScreenFor(DataBean data) {
        this.historyScreen.setData(data);
        this.childScreens.show("History", true);
    }

    @Override
    public void showDetailsFor(DataBean data) {
        this.details.setViewedData(data);
    }

    @Override
    public Icon getIconFor(DataItem element) {
        if (element instanceof DataFolder) {
            return VisualConstants.ICON_TYPE_FOLDER;
        }
        DataBean bean = (DataBean)element;
        if (bean.queryFeatures("/phenodata").exists()) {
            return VisualConstants.ICON_TYPE_PHENODATA;
        }
        return bean.getContentType().getIcon();
    }

    public void restoreDefaultView() {
        this.leftSplit.setDividerLocation(250);
        this.mainSplit.setDividerLocation(360);
        this.rightSplit.setDividerLocation(250);
        this.mainSplit.validate();
    }

    @Override
    public void reportTaskError(Task task) throws MicroarrayException {
        String message;
        String title;
        boolean userFixable;
        boolean bl = userFixable = task.getState() == Task.State.FAILED_USER_ERROR && task.getErrorMessage() != null && !task.getErrorMessage().equals("");
        if (userFixable) {
            title = task.getErrorMessage();
            message = task.getNamePrettyPrinted() + " was stopped. ";
        } else {
            title = task.getNamePrettyPrinted() + " did not complete successfully. ";
            message = "You may have used a tool or parameters which are unsuitable for the selected dataset, or there might be a bug in the analysis tool itself.\n\nThe details below may provide hints about the problem.";
        }
        String details = "";
        if (task.getErrorMessage() != null) {
            details = details + task.getErrorMessage() + "\n\n";
        }
        details = details + "----------------------------------------------------------------------\n";
        if (task.getScreenOutput() != null) {
            details = details + task.getScreenOutput();
        }
        ChipsterDialog.DetailsVisibility detailsVisibility = userFixable ? ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN : ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN;
        DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.INFO, title, message, details);
        if (!userFixable) {
            dialogInfo.setFeedbackVisible(true);
        }
        ChipsterDialog.showDialog(this, dialogInfo, detailsVisibility, false);
    }

    @Override
    public void reportExceptionThreadSafely(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingClientApplication.this.reportException(e);
            }
        });
    }

    @Override
    public void reportException(Exception e) {
        DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.ERROR, "An error has occurred and the action was not performed successfully.", "If problem persist, please check that your data is valid. For more information open the details panel below.", null);
        dialogInfo.setFeedbackVisible(true);
        if (e instanceof ErrorReportAsException) {
            ErrorReportAsException report = (ErrorReportAsException)e;
            dialogInfo.setTitle(report.getTitle());
            dialogInfo.setMessage(report.getMessage());
            dialogInfo.setDetails(report.getDetails());
        } else if (e instanceof MicroarrayException) {
            MicroarrayException me = (MicroarrayException)e;
            String details = "";
            if (e.getMessage() != null) {
                details = details + e.getMessage() + "\n";
            }
            if (ErrorDialogUtils.getMessage(me.getExtraInfo()) != null) {
                details = details + ErrorDialogUtils.getMessage(me.getExtraInfo()) + "\n";
            }
            if (ErrorDialogUtils.getScreenOutput(me.getExtraInfo()) != null) {
                details = details + ErrorDialogUtils.getScreenOutput(me.getExtraInfo());
            }
            dialogInfo.setDetails(details);
        } else {
            dialogInfo.setDetails(Exceptions.getStackTrace(e));
        }
        ChipsterDialog.showDialog(this, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, false);
        e.printStackTrace();
        if (logger != null) {
            logger.error((Object)Exceptions.getStackTrace(e));
        }
    }

    public void onException(JMSException e) {
        this.reportException((Exception)((Object)e));
    }

    public void showChildScreen(String name, boolean packed) {
        this.childScreens.show(name, packed);
    }

    public void showMaximisedVisualisation(boolean maximised) {
        if (maximised) {
            this.mainSplit.setDividerLocation(0);
            this.rightSplit.setDividerLocation(0);
        } else {
            this.restoreDefaultView();
        }
        this.rightSideViewChanger.validate();
    }

    @Override
    public void showPopupMenuFor(MouseEvent e, DataItem data) {
        ArrayList<DataItem> datas = new ArrayList<DataItem>();
        datas.add(data);
        this.showPopupMenuFor(e, datas);
    }

    @Override
    public void showPopupMenuFor(MouseEvent e, List<DataItem> datas) {
        ClientContextMenu popup = new ClientContextMenu(this);
        popup.setOptionsFor(datas);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public boolean isSelectedDataVisualisable() {
        return this.getDefaultVisualisationForSelection() != VisualisationMethod.NONE;
    }

    private VisualisationMethod getDefaultVisualisationForSelection() {
        logger.debug((Object)"getting default visualisation");
        if (this.getSelectionManager().getSelectedDataBeans() == null || this.getSelectionManager().getSelectedDataBeans().size() == 0) {
            return VisualisationMethod.NONE;
        }
        try {
            List<DataBean> beans = this.getSelectionManager().getSelectedDataBeans();
            if (beans.size() == 1) {
                return Session.getSession().getVisualisations().getDefaultVisualisationFor(beans.get(0));
            }
            if (beans.size() > 1) {
                for (VisualisationMethod method : Session.getSession().getVisualisations().getOrderedDefaultCandidates()) {
                    if (method == VisualisationMethod.NONE || !method.getHeadlessVisualiser().isForMultipleDatas() || !method.isApplicableTo(beans)) continue;
                    return method;
                }
            }
            return VisualisationMethod.NONE;
        }
        catch (Exception e) {
            this.reportException(e);
            return VisualisationMethod.NONE;
        }
    }

    @Override
    public void visualiseWithBestMethod(VisualisationFrameManager.FrameType target) {
        this.setVisualisationMethod(this.getDefaultVisualisationForSelection(), null, this.getSelectionManager().getSelectedDataBeans(), target);
    }

    @Override
    public void deleteDatas(DataItem ... datas) {
        if (datas.length == 0) {
            return;
        }
        JLabel confirmMessage = null;
        if (datas.length > 1) {
            confirmMessage = new JLabel("Really delete " + datas.length + " data items?");
        } else if (datas[0] instanceof DataFolder) {
            confirmMessage = new JLabel("Really delete " + datas[0].getName() + " and all of its contents?");
        } else if (datas[0] instanceof DataBean) {
            confirmMessage = new JLabel("Really delete " + datas[0].getName() + " ?");
        } else {
            throw new IllegalArgumentException("datas is illegal");
        }
        if (JOptionPane.showConfirmDialog(this.mainFrame, confirmMessage, "Delete items", 0) != 0) {
            return;
        }
        this.deleteDatasWithoutConfirming(datas);
    }

    public void deleteDatasWithoutConfirming(DataItem ... datas) {
        if (datas.length == 0) {
            return;
        }
        this.getSelectionManager().clearAll(true, this);
        for (DataItem data : datas) {
            this.manager.delete(data);
        }
    }

    public void fixFileChooserFontSize(JFileChooser fileChooser) {
        if (fileChooser != null) {
            UIManager.put("FileChooser.listFont", UIManager.getFont("List.font").deriveFont(fontSize));
            SwingUtilities.updateComponentTreeUI(fileChooser);
        }
    }

    public void openFileImport() throws MicroarrayException, IOException {
        JFileChooser fc = this.getImportExportFileChooser();
        fc.setMultiSelectionEnabled(true);
        ImportSettingsAccessory access = (ImportSettingsAccessory)this.importExportFileChooser.getAccessory();
        access.setDefaults();
        int ret = fc.showOpenDialog(this.getMainFrame());
        if (ret == 0) {
            ArrayList<File> files = new ArrayList<File>();
            for (File file : fc.getSelectedFiles()) {
                files.add(file);
            }
            ImportSession importSession = new ImportSession(ImportSession.Source.FILES, files, access.getImportFolder(), access.skipActionChooser());
            ImportUtils.executeImport(importSession);
        }
    }

    public void openDirectoryImportDialog() {
        JFileChooser fc = this.getImportExportDirChooser();
        fc.setSelectedFile(new File(""));
        int ret = fc.showOpenDialog(this.getMainFrame());
        if (ret == 0) {
            File selectedFile = fc.getSelectedFile();
            super.importWholeDirectory(selectedFile);
        }
    }

    public void openURLImport() throws MicroarrayException, IOException {
        URLImportDialog urlImportDlg = new URLImportDialog(this);
        URL selectedURL = urlImportDlg.getSelectedURL();
        String importFolder = urlImportDlg.getSelectedFolderName();
        if (selectedURL != null) {
            File file = ImportUtils.createTempFile(ImportUtils.URLToFilename(selectedURL), ImportUtils.getExtension(ImportUtils.URLToFilename(selectedURL)));
            ImportUtils.getURLFileLoader().loadFileFromURL(selectedURL, file, importFolder, urlImportDlg.isSkipSelected());
        }
    }

    @Override
    protected void quit() {
        int returnValue = -1;
        if (this.taskExecutor.getRunningTaskCount() > 0) {
            String message = "";
            message = this.taskExecutor.getRunningTaskCount() == 1 ? message + "There is a running task.  Are you sure you want to cancel the running task?" : message + "There are " + this.taskExecutor.getRunningTaskCount() + " running tasks. " + "Are you sure you want to cancel all running tasks?";
            Object[] options = new Object[]{"Cancel running tasks", "Cancel"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Confirm close", 0, 3, null, options, options[0]);
            if (returnValue == 0) {
                this.taskExecutor.killAll();
            } else {
                return;
            }
        }
        returnValue = -1;
        if (this.unsavedChanges) {
            Object[] options = new Object[]{"Save and close", "Close without saving", "Cancel"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), "Do you want the session to be saved before closing Chipster?", "Confirm close", 1, 3, null, options, options[0]);
            if (returnValue == 0) {
                try {
                    this.saveSessionAndQuit();
                    return;
                }
                catch (Exception exp) {
                    this.showErrorDialog("Session saving failed", exp);
                    return;
                }
            }
            if (returnValue != 1) {
                return;
            }
        }
        this.quitImmediately();
    }

    public void quitImmediately() {
        this.childScreens.disposeAll();
        this.mainFrame.setVisible(false);
        super.quit();
        this.mainFrame.dispose();
        System.exit(0);
    }

    private static ClientListener getShutdownListener() {
        ClientListener shutdownListener = new ClientListener(){

            @Override
            public void onSuccessfulInitialisation() {
            }

            @Override
            public void onFailedInitialisation() {
                System.exit(1);
            }
        };
        return shutdownListener;
    }

    public static void start(String configURL, String module) throws IOException {
        block4: {
            try {
                DirectoryLayout.initialiseClientLayout(configURL);
            }
            catch (ConfigurationLoader.IllegalConfigurationException e) {
                SwingClientApplication.reportIllegalConfigurationException(e);
            }
            ClientListener shutdownListener = SwingClientApplication.getShutdownListener();
            try {
                new SwingClientApplication(shutdownListener, null, module);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (logger == null) break block4;
                logger.error((Object)Exceptions.getStackTrace(t));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        SwingClientApplication.start(null, "fi.csc.microarray.module.chipster.MicroarrayModule");
    }

    public static void reportIllegalConfigurationException(ConfigurationLoader.IllegalConfigurationException e) {
        DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.ERROR, "Illegal configuration", "Chipster could not start because the provided configuration file is illegal. Please contact your system administrator.", "Reason: " + e.getMessage());
        ChipsterDialog.showDialog(null, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, true);
        throw new RuntimeException("configuration not compatible, will not start");
    }

    @Override
    public void showSourceFor(String operationID) throws TaskException {
        this.childScreens.show("ShowSource", true, operationID);
    }

    public void exportFolder(DataFolder data) throws MicroarrayException, IOException {
        File file = new File(data.getName().replace(" ", "_"));
        JFileChooser fc = this.getImportExportDirChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(file);
        logger.debug((Object)("Exporting File: " + fc.getSelectedFile().getAbsolutePath()));
        int ret = fc.showSaveDialog(this.getMainFrame());
        if (ret == 0) {
            File selected = new File(fc.getSelectedFile().getAbsolutePath() + File.separator + file.getName());
            selected.mkdirs();
            this.exportDataFolder(data, selected);
        }
    }

    private void exportDataFolder(DataFolder source, File dir) throws IOException, MicroarrayException {
        for (DataItem child : source.getChildren()) {
            if (child instanceof DataBean) {
                String filename = this.createFilename((DataBean)child);
                filename = dir.getAbsolutePath() + File.separator + filename;
                logger.debug((Object)("Exporting dataBean " + child.getName() + " into " + filename));
                this.exportToFile((DataBean)child, new File(filename));
                continue;
            }
            if (!(child instanceof DataFolder)) continue;
            logger.debug((Object)("Exporting dataFolder " + child.getName()));
            String foldername = dir.getAbsolutePath() + File.separator + child.getName().replace(" ", "_");
            File file = new File(foldername);
            file.mkdir();
            this.exportDataFolder((DataFolder)child, file);
        }
    }

    public void exportDataset(DataBean data) throws MicroarrayException, IOException {
        JFileChooser fc = this.getImportExportFileChooser();
        fc.setDialogType(1);
        String proposedName = this.createFilename(data);
        fc.setSelectedFile(new File(proposedName));
        int ret = fc.showSaveDialog(this.getMainFrame());
        if (ret == 0) {
            File selectedFile = fc.getSelectedFile();
            this.exportToFile(data, selectedFile);
        }
    }

    private String createFilename(DataBean data) {
        String proposedName = data.getName().replace(" ", "_");
        return proposedName;
    }

    @Override
    public void setMaximisedVisualisationMode(boolean maximisedVisualisationMode) {
        this.showMaximisedVisualisation(maximisedVisualisationMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVisualisationMethod(VisualisationMethod method, List<Visualisation.Variable> variables, List<DataBean> datas, VisualisationFrameManager.FrameType target) {
        if (method == null || datas == null) {
            super.setVisualisationMethod(VisualisationMethod.NONE, null, null, target);
            return;
        }
        long estimate = method.estimateDuration(datas);
        if (estimate > 5000L) {
            int severity;
            int returnValue = -1;
            String message = "";
            if (estimate > 20000L) {
                message = message + "Visualising the selected large dataset with this method might stop Chipster from responding. \nIf you choose to continue, it's recommended to save the session before visualising.";
                severity = 2;
            } else {
                message = message + "Are you sure you want to visualise large dataset, which may take several seconds?";
                severity = 3;
            }
            Object[] options = new Object[]{"Cancel", "Visualise"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Cancel visualisation", 0, severity, null, options, options[0]);
            if (returnValue != 1) return;
            super.setVisualisationMethod(method, variables, datas, target);
            return;
        } else {
            super.setVisualisationMethod(method, variables, datas, target);
        }
    }

    public void exportSelectedItems() {
        try {
            for (DataItem item : this.getSelectionManager().getSelectedDataItems()) {
                if (item instanceof DataBean) {
                    this.exportDataset((DataBean)item);
                    continue;
                }
                if (!(item instanceof DataFolder)) continue;
                this.exportFolder((DataFolder)item);
            }
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    private JFileChooser getImportExportDirChooser() {
        if (this.importExportFileChooser == null) {
            this.importExportFileChooser = ImportUtils.getFixedFileChooser();
        }
        this.importExportFileChooser.setAccessory(null);
        this.importExportFileChooser.setFileSelectionMode(1);
        String description = "Data Directory";
        String[] extensions = new String[]{};
        for (FileFilter filter : this.importExportFileChooser.getChoosableFileFilters()) {
            this.importExportFileChooser.removeChoosableFileFilter(filter);
        }
        this.importExportFileChooser.addChoosableFileFilter(new GeneralFileFilter(description, extensions));
        this.importExportFileChooser.setAcceptAllFileFilterUsed(false);
        this.fixFileChooserFontSize(this.importExportFileChooser);
        return this.importExportFileChooser;
    }

    public JFileChooser getImportExportFileChooser() {
        if (this.importExportFileChooser == null) {
            this.importExportFileChooser = ImportUtils.getFixedFileChooser();
        }
        for (FileFilter filter : this.importExportFileChooser.getChoosableFileFilters()) {
            this.importExportFileChooser.removeChoosableFileFilter(filter);
        }
        this.importExportFileChooser.setFileSelectionMode(0);
        this.importExportFileChooser.setAcceptAllFileFilterUsed(true);
        ImportSettingsAccessory access = new ImportSettingsAccessory(this.importExportFileChooser);
        this.importExportFileChooser.setAccessory(access);
        this.fixFileChooserFontSize(this.importExportFileChooser);
        return this.importExportFileChooser;
    }

    private JFileChooser getSessionFileChooser(JComponent accessory) {
        if (this.sessionFileChooser == null) {
            this.sessionFileChooser = ImportUtils.getFixedFileChooser();
            String[] extensions = new String[]{"zip"};
            this.sessionFileChooser.setFileFilter(new GeneralFileFilter("Chipster Session (.zip)", extensions));
            this.sessionFileChooser.setSelectedFile(new File("session.zip"));
            this.sessionFileChooser.setAcceptAllFileFilterUsed(false);
            this.sessionFileChooser.setMultiSelectionEnabled(false);
        }
        this.sessionFileChooser.setAccessory(accessory);
        this.fixFileChooserFontSize(this.sessionFileChooser);
        return this.sessionFileChooser;
    }

    private JFileChooser getWorkflowFileChooser() {
        if (this.workflowFileChooser == null) {
            this.workflowFileChooser = ImportUtils.getFixedFileChooser(this.workflowManager.getScriptDirectory());
            this.workflowFileChooser.setFileFilter(WorkflowManager.FILE_FILTER);
            this.workflowFileChooser.setSelectedFile(new File("workflow.bsh"));
            this.workflowFileChooser.setAcceptAllFileFilterUsed(false);
            this.workflowFileChooser.setMultiSelectionEnabled(false);
        }
        this.fixFileChooserFontSize(this.workflowFileChooser);
        return this.workflowFileChooser;
    }

    public void openImportTool(ImportSession importSession) {
        ImportScreen importScreen = (ImportScreen)this.childScreens.get("Import");
        importScreen.setImportSession(importSession);
        importScreen.updateTable(false);
        this.childScreens.show("Import", false);
    }

    @Override
    public void runBlockingTask(String taskName, final Runnable runnable) {
        Thread backgroundThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingClientApplication.this.reportException(e);
                        }
                    });
                }
                finally {
                    SwingClientApplication.this.waitPanel.stopWaiting();
                    SwingClientApplication.this.updateWindowTitleBlockingState(null);
                }
            }
        });
        this.waitPanel.startWaiting("<html>Please wait while " + taskName + "..." + "</html>");
        this.updateWindowTitleBlockingState(taskName);
        backgroundThread.start();
    }

    @Override
    public void viewHelpFor(OperationDefinition definition) {
        String url = definition.getHelpURL();
        url = url != null && !url.isEmpty() ? definition.getHelpURL() : HelpMapping.mapToHelppage(definition);
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    @Override
    public void viewHelp(String page) {
        try {
            if (!page.startsWith(HelpMapping.MANUAL_ROOT)) {
                page = HelpMapping.MANUAL_ROOT + page;
            }
            BrowserLauncher.openURL(page);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    protected void garbageCollect() {
        System.gc();
        this.statusBar.updateMemoryIndicator();
    }

    public TaskManagerScreen getTaskManagerScreen() {
        TaskExecutor taskExecutor = Session.getSession().getServiceAccessor().getTaskExecutor();
        return new TaskManagerScreen(taskExecutor);
    }

    @Override
    public void createLink(DataBean source, DataBean target, DataBean.Link type) {
        source.addLink(type, target);
    }

    @Override
    public void removeLink(DataBean source, DataBean target, DataBean.Link type) {
        source.removeLink(type, target);
    }

    @Override
    public void showImportToolFor(File file, String destinationFolder, boolean skipActionChooser) {
        ImportSession importSession = new ImportSession(ImportSession.Source.FILES, new File[]{file}, destinationFolder, skipActionChooser);
        this.openImportTool(importSession);
    }

    @Override
    public void loadSessionFrom(File file) {
        this.loadSessionImpl(file, SessionLoader.LoadMethod.NORMAL);
    }

    @Override
    public void restoreSessionFrom(File file) {
        this.loadSessionImpl(file, SessionLoader.LoadMethod.LIGHTWEIGHT);
    }

    @Override
    public void loadSessionFrom(URL url) {
        try {
            final File tempFile = ImportUtils.createTempFile(ImportUtils.URLToFilename(url), ImportUtils.getExtension(ImportUtils.URLToFilename(url)));
            InformationDialog info = new InformationDialog("Loading session", "Loading session from the specified URL", null);
            ImportUtils.FileLoaderProcess fileLoaderProcess = new ImportUtils.FileLoaderProcess(tempFile, url, info){

                @Override
                protected void postProcess() {
                    SwingClientApplication.this.loadSessionImpl(tempFile, SessionLoader.LoadMethod.NORMAL);
                }
            };
            fileLoaderProcess.runProcess();
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    @Override
    public void loadSession() {
        this.loadSession(SessionLoader.LoadMethod.NORMAL);
    }

    public void loadSession(SessionLoader.LoadMethod loadMethod) {
        SnapshotAccessory accessory = new SnapshotAccessory();
        JFileChooser fileChooser = this.getSessionFileChooser(accessory);
        int ret = fileChooser.showOpenDialog(this.getMainFrame());
        if (ret == 0) {
            File sessionFile = fileChooser.getSelectedFile();
            if (!sessionFile.exists()) {
                DialogInfo info = new DialogInfo(DialogInfo.Severity.INFO, "Could not open session file.", "File '" + sessionFile.getName() + "' not found.", "", DialogInfo.Type.MESSAGE);
                ChipsterDialog.showDialog(this, info, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, true);
                return;
            }
            if (!UserSession.isValidSessionFile(sessionFile)) {
                DialogInfo info = new DialogInfo(DialogInfo.Severity.INFO, "Could not open session file.", "File '" + sessionFile.getName() + "' is not a valid session file.", "", DialogInfo.Type.MESSAGE);
                ChipsterDialog.showDialog(this, info, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, true);
                return;
            }
            if (accessory.clearSession() && !this.clearSession()) {
                return;
            }
            this.loadSessionImpl(fileChooser.getSelectedFile(), loadMethod);
        }
        this.menuBar.updateMenuStatus();
    }

    private void loadSessionImpl(final File sessionFile, final SessionLoader.LoadMethod loadMethod) {
        if (!UserSession.isValidSessionFile(sessionFile)) {
            DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.INFO, "Could not open session file.", "The given file is not a valid session file.", "");
            ChipsterDialog.showDialog(this, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, true);
            return;
        }
        this.runBlockingTask("loading the session", new Runnable(){

            @Override
            public void run() {
                boolean somethingToSave = SwingClientApplication.this.manager.databeans().size() != 0;
                SwingClientApplication.this.manager.loadSession(sessionFile, loadMethod);
                SwingClientApplication.this.unsavedChanges = somethingToSave;
                if (loadMethod.equals((Object)SessionLoader.LoadMethod.LIGHTWEIGHT)) {
                    SwingClientApplication.this.clearDeadTempDirectories();
                }
            }
        });
    }

    @Override
    public void saveSession() {
        this.saveSession(false);
    }

    public void saveSessionAndQuit() {
        this.saveSession(true);
    }

    public void saveSession(final boolean quit) {
        JFileChooser fileChooser = this.getSessionFileChooser(null);
        int ret = fileChooser.showSaveDialog(this.getMainFrame());
        if (ret == 0) {
            try {
                File file;
                File file2 = file = fileChooser.getSelectedFile().getName().endsWith(".zip") ? fileChooser.getSelectedFile() : new File(fileChooser.getSelectedFile().getCanonicalPath() + "." + "zip");
                if (file.exists()) {
                    int returnValue = -1;
                    String message = "The file " + file.getCanonicalPath() + " already exists. Do you want " + "to replace it?";
                    Object[] options = new Object[]{"Cancel", "Replace"};
                    returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Confirm replace", 0, 3, null, options, options[0]);
                    if (returnValue != 1) {
                        return;
                    }
                }
                this.runBlockingTask("saving session", new Runnable(){

                    @Override
                    public void run() {
                        boolean saveSuccessful = SwingClientApplication.this.getDataManager().saveSession(file);
                        if (saveSuccessful) {
                            if (quit) {
                                SwingClientApplication.this.quitImmediately();
                            }
                            SwingClientApplication.this.menuBar.updateMenuStatus();
                            SwingClientApplication.this.unsavedChanges = false;
                        }
                    }
                });
            }
            catch (Exception exp) {
                this.showErrorDialog("Saving session failed.", exp);
                return;
            }
        }
        this.menuBar.updateMenuStatus();
    }

    public boolean clearSession() {
        int returnValue = -1;
        if (this.unsavedChanges) {
            String message = "The current session contains unsaved changes.\nDo you want to clear it anyway?";
            Object[] options = new Object[]{"Cancel", "Clear"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Clear session", 0, 3, null, options, options[0]);
        }
        if (!this.unsavedChanges || returnValue == 1) {
            this.deleteDatasWithoutConfirming(this.manager.getRootFolder());
            this.unsavedChanges = false;
            return true;
        }
        return false;
    }

    @Override
    public void checkFreeMemory() {
        this.statusBar.updateMemoryIndicator();
    }

    @Override
    public DataManager getDataManager() {
        return this.manager;
    }

    @Override
    public VisualisationFrameManager getVisualisationFrameManager() {
        return this.visualisationFrameManager;
    }

    @Override
    public void flipTaskListVisibility(boolean closeIfVisible) {
        this.statusBar.flipTaskListVisibility(closeIfVisible);
    }

    @Override
    protected void taskCountChanged(int newTaskCount, boolean attractAttention) {
        int completion = 0;
        if (newTaskCount > 0) {
            completion = this.taskExecutor.getTasks(true, false).iterator().next().getCompletionPercentage();
        }
        this.statusBar.taskCountChanged(newTaskCount, completion, attractAttention);
    }

    public void refreshTaskList() {
        this.taskManagerScreen.refreshTasks();
    }

    public Screen getTaskListScreen() {
        return this.childScreens.get("TaskList");
    }

    private void enableKeyboardShortcuts() {
        final HashMap<KeyStroke, 14> shortcutActionMap = new HashMap<KeyStroke, 14>();
        shortcutActionMap.put(KeyStroke.getKeyStroke(79, 704), new AbstractAction("OPEN_LIGHTWEIGHT_SESSION"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingClientApplication.this.loadSession(SessionLoader.LoadMethod.FEEDBACK);
            }
        });
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                if (shortcutActionMap.containsKey(keyStroke)) {
                    final Action a = (Action)shortcutActionMap.get(keyStroke);
                    final ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            a.actionPerformed(ae);
                        }
                    });
                    return true;
                }
                return false;
            }
        });
    }

    static {
        fontSize = 11.0f;
    }

    private static class CustomExperienceBlue
    extends ExperienceBlue {
        private CustomExperienceBlue() {
        }

        public ColorUIResource getFocusColor() {
            return new ColorUIResource(VisualConstants.PLASTIC3D_FOCUS_COLOR);
        }

        public FontUIResource getControlTextFont() {
            return new FontUIResource(super.getControlTextFont().deriveFont(fontSize));
        }

        public FontUIResource getTitleTextFont() {
            return new FontUIResource(super.getTitleTextFont().deriveFont(fontSize));
        }

        public FontUIResource getSubTextFont() {
            return new FontUIResource(super.getSubTextFont().deriveFont(fontSize));
        }

        public FontUIResource getSystemTextFont() {
            return new FontUIResource(super.getSystemTextFont().deriveFont(fontSize));
        }

        public FontUIResource getUserTextFont() {
            return new FontUIResource(super.getUserTextFont().deriveFont(fontSize));
        }

        public FontUIResource getWindowTitleFont() {
            return new FontUIResource(super.getWindowTitleFont().deriveFont(fontSize));
        }

        public FontUIResource getMenuTextFont() {
            return new FontUIResource(super.getMenuTextFont().deriveFont(fontSize));
        }
    }
}

