/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private Class type;

    public BeanDefinitionParser(Class type) {
        this.type = type;
    }

    protected Class getBeanClass(Element element) {
        return this.type;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return attributeName != null && !"id".equals(attributeName) && !attributeName.equals("xmlns") && !attributeName.startsWith("xmlns:");
    }

    protected final void doParse(Element element, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            String fullName = attribute.getName();
            if (fullName.startsWith("xmlns:") || fullName.equals("xmlns") || !this.isEligibleAttribute(name)) continue;
            String propertyName = this.extractPropertyName(name);
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
        this.postProcess(builder, element);
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
    }
}

