/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.ui.PaintSample;

public class GradientColorPaletteEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private JCheckBox logarithmicCB;
    private GradientColorPalette palette = null;
    private ColorInfo[] colors = null;

    public void setColoring(GradientColorPalette palette) {
        this.palette = palette;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.logarithmicCB) {
            boolean value = this.logarithmicCB.isSelected();
            this.palette.setLinear(!value);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.viski_bundle.LocalizationBundle");
        if (this.colors == null) {
            return;
        }
        for (int i = 0; i < this.colors.length; ++i) {
            if (e.getSource() != this.colors[i].button) continue;
            Color color = this.palette.getKeyColor(this.colors[i].value);
            color = JColorChooser.showDialog(this, lr.getString("Change_color") + i, color);
            if (color == null) continue;
            this.colors[i].sample.setPaint((Paint)color);
            this.palette.setKeyColor(this.colors[i].value, color);
        }
    }

    public JPanel getPanel() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.viski_bundle.LocalizationBundle");
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        c.fill = 3;
        c.insets = new Insets(5, 2, 5, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.colors = new ColorInfo[this.palette.getKeyColors().length];
        int i = 0;
        for (double value : this.palette.getKeyValues()) {
            ColorInfo color = new ColorInfo();
            color.value = value;
            c.gridx = 0;
            color.label = new JLabel("");
            panel.add((Component)color.label, c);
            c.gridx = 1;
            color.sample = new PaintSample((Paint)this.palette.getKeyColors()[i]);
            panel.add((Component)color.sample, c);
            c.gridx = 2;
            color.button = new JButton(lr.getString("Change"));
            panel.add((Component)color.button, c);
            color.button.addActionListener(this);
            this.colors[i] = color;
            ++c.gridy;
            ++i;
        }
        this.createPanelTexts();
        c.gridx = 0;
        this.logarithmicCB = new JCheckBox(lr.getString("Use_logarithmic_scale"), !this.palette.isLinear());
        this.logarithmicCB.addChangeListener(this);
        panel.add((Component)this.logarithmicCB, c);
        return panel;
    }

    private void createPanelTexts() {
        int i = 0;
        for (double value : this.palette.getKeyValues()) {
            this.colors[i].value = value;
            String nameOfColor = i == 0 ? "Color for minimum value " + this.palette.getOriginalMinMaxValues()[0] : (i == 1 ? "Color for average of min and max " : "Color for maximum value " + this.palette.getOriginalMinMaxValues()[1]);
            this.colors[i].label.setText(nameOfColor);
            this.colors[i].label.repaint();
            ++i;
        }
    }

    private class ColorInfo {
        private PaintSample sample;
        private JButton button;
        private double value;
        private JLabel label;

        private ColorInfo() {
        }
    }
}

