# TOOL select_columns.R: "Table converter" (Tool to select columns from tables and to convert text files into tables.)
# INPUT input: "Query sequences" TYPE GENERIC
# OUTPUT selected.tsv
# PARAMETER cols: "Column list" TYPE STRING (Select columns to be printed. Use comma separated lists of cloumn numbers like 3,1,5 )
# PARAMETER OPTIONAL colnames: "Column name list" TYPE STRING (Add a new header row for the selected columns. Use comma separated lists of column names like source,date,name. By default the first imported row is used a as a header row. )
# PARAMETER OPTIONAL sep: "Column separator in input file" TYPE [tab: "tabulator", space: "space or tabulator", semic: "semicolon (\;\)", doubp: "double point(\:\)", comma: "comma (\,\)", pipe: "pipe (\|\)"] DEFAULT tab (Select the column separator used to parse the input data. By default, chipster uses tabulator.)  
# PARAMETER OPTIONAL startrow: "First row to read" TYPE INTEGER DEFAULT 1 (Skip the first few lines of the input dataset. Note that in table files, the header row is considered as a the first row)

# KM 8.11. 2013


#create new header if defined
if ( nchar(colnames) > 0 ){
	command.full <- paste('echo ')
	for ( i in unlist(strsplit(colnames, split=","))){
		command.full <- paste(command.full,i,'"\\t"', sep="")
	}
	command.full <- paste(command.full,' > selected.tsv1', sep="")
	#stop(paste("CHIPSTER-NOTE:", command.full))
	system(command.full)
}

#AWK command to create the datarows


# replace tabs with spaces if other separators are used
if ( sep != "tab"){
   system ('cat input | tr "\t" " " > input.tmp ')	
   system ('rm -f input')
   system ('mv input.tmp input')
}


if ( sep == "tab"){
	command.start <- paste('awk -F "\\t" \'{ if ( NR >=', startrow, ' )  print ')	
}
if ( sep == "space"){
	command.start <- paste('awk \'{if ( NR >=', startrow, ' )  print ') 
}
if ( sep == "semic"){
	command.start <- paste('awk -F ";" \'{if ( NR >=', startrow, ' )  print ') 
}
if ( sep == "doubp"){
	command.start <- paste('awk -F ":" \'{if ( NR >=', startrow, ' )  print ') 
}
if ( sep == "comma"){
	command.start <- paste('awk -F "," \'{if ( NR >=', startrow, ' )  print ') 
}
if ( sep == "pipe"){
	command.start <- paste('awk -F "|" \'{if ( NR >=', startrow, ' )  print ') 
}


command.full <- paste(command.start)

for ( i in unlist(strsplit(cols, split=","))){
	command.full <- paste(command.full,'$',i,'"\\t"', sep="")				
}

command.full <- paste(command.full,"}' input >> selected.tsv1  2>&1")
#stop(paste("CHIPSTER-NOTE:", command.full))
system(command.full)

system('sed -e s/"\t$"/""/g selected.tsv1 > selected.tsv' )



