package org.jfree.chart.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.util.EventListener;
import javax.swing.event.CaretListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.MultiChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import java.util.ArrayList;

/**
 * Tests for the {@link MultiChartPanel} class.
 * Partly taken from JFreeChart's ChartPanel tests
 */
public class MultiChartPanelTests extends TestCase implements ChartMouseListener {

    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(MultiChartPanelTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public MultiChartPanelTests(String name) {
        super(name);
    }

    /**
     * Test that the constructor will accept a null chart.
     */
    public void testConstructor1() {
        MultiChartPanel panel = new MultiChartPanel(null, new ArrayList()); 
        assertEquals(null, panel.getChart());
    }
    
    /**
     * Test that it is possible to set the panel's chart to null
     * and some other stuff
     */
    public void testSetChart() {
        JFreeChart chart = new JFreeChart(new XYPlot());
        MultiChartPanel panel = new MultiChartPanel(chart, new ArrayList());
        panel.setChart(null);
        assertEquals(null, panel.getChart());
        MultiChartPanel panel2 = new MultiChartPanel(chart, true, new ArrayList());
        MultiChartPanel panel3 = new MultiChartPanel(chart, true, true, 
            true, true, true, new ArrayList());
        MultiChartPanel panel4 = new MultiChartPanel(chart, 3, 4, 5, 6, 
            7, 8, false, false, false, false, false, false, null);
        assertEquals(5, panel4.getMinimumDrawWidth());
        assertEquals(6, panel4.getMinimumDrawHeight());
        assertEquals(7, panel4.getMaximumDrawWidth());
        assertEquals(8, panel4.getMaximumDrawHeight());
        assertEquals(false, panel4.getRefreshBuffer());
        MultiChartPanel panel5 = new MultiChartPanel(null, panel);
/*
        try {
        panel5.doSaveAs();}
        catch (java.io.IOException e) {
        assertTrue(true); }

        try {
        panel.doSaveAs();}
        catch (java.io.IOException e) {
        assertTrue(false); }
*/
        assertEquals(java.awt.print.Printable.NO_SUCH_PAGE, panel5.print(null, null, 1));
        try {
        panel5.print(null, null, 0); } 
        catch (NullPointerException e) {
        assertTrue(true); }
    }
    
    /**
     * Check the behaviour of the getListeners() method.
     */
    public void testGetListeners() {
        MultiChartPanel p = new MultiChartPanel(null, new ArrayList());
        p.addChartMouseListener(this);
        EventListener[] listeners = p.getListeners(ChartMouseListener.class);
        assertEquals(1, listeners.length);
        assertEquals(this, listeners[0]);
        // try a listener type that isn't registered
        listeners = p.getListeners(CaretListener.class);
        assertEquals(0, listeners.length);
        p.removeChartMouseListener(this);
        listeners = p.getListeners(ChartMouseListener.class);
        assertEquals(0, listeners.length);
    
        // try a null argument
        boolean pass = false;
        try {
            listeners = p.getListeners(null);
        }
        catch (NullPointerException e) {
            pass = true;    
        }
        assertTrue(pass);
    
        // try a class that isn't a listener
        pass = false;
        try {
            listeners = p.getListeners(Integer.class);
        }
        catch (ClassCastException e) {
            pass = true;
        }
        assertTrue(pass);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        // ignore
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        // ignore
    }

}
