/*
 * Line.java
 *
 * Created on 30. toukokuuta 2006, 19:03
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package threed;

import java.awt.Graphics;
import java.awt.Color;

/**
 *
 * @author esa
 */
public class Line 
        extends Drawable {
    
    /**
     * Creates a new instance of Line
     * @param x1 
     * @param y1 
     * @param z1 
     * @param x2 
     * @param y2 
     * @param z2 
     * @param color 
     * @param text 
     */
    public Line(double x1, double y1, double z1,
            double x2, double y2, double z2, Color color, String text) {
        this.visualisationCoords = new double[2][3];
        this.projectedCoords = new double[2][2];
        this.deviceCoords = new int[2][2];
        this.dataCoords = new double[2][3];
        this.distanceFromCamera = new double[2];
        this.text = text;
        
        dataCoords[0][0] = visualisationCoords[0][0] = x1;
        dataCoords[0][1] = visualisationCoords[0][1] = y1;
        dataCoords[0][2] = visualisationCoords[0][2] = z1;
        dataCoords[1][0] = visualisationCoords[1][0] = x2;
        dataCoords[1][1] = visualisationCoords[1][1] = y2;
        dataCoords[1][2] = visualisationCoords[1][2] = z2;
        this.color = color;
    }
    
    /**
     * 
     * @param g 
     * @param width 
     * @param height 
     */
    public void draw(Graphics g, int width, int height) {
        if (/*Math.abs(projectedCoords[0][0]) > 0.5 || 
                Math.abs(projectedCoords[0][1]) > 0.5 ||*/
                this.hidden == true) {
            return;
        }
        g.setColor(color);
        deviceCoords[0][0] = (int)((projectedCoords[0][0] + 0.5) * width);
        deviceCoords[0][1] = (int)((projectedCoords[0][1] + 0.5) * height);
        deviceCoords[1][0] = (int)((projectedCoords[1][0] + 0.5) * width);
        deviceCoords[1][1] = (int)((projectedCoords[1][1] + 0.5) * height);
        
        g.drawLine(deviceCoords[0][0], deviceCoords[0][1], 
                deviceCoords[1][0], deviceCoords[1][1]);
        if (this.text != null) {
            g.drawString(this.text, deviceCoords[1][0], deviceCoords[1][1]);
        }
    }

    /**
     * 
     * @param camera 
     * @param planeDistance 
     * @param viewWindowWidth 
     * @param viewWindowHeight 
     */
    public void setDistanceFromCamera(
            double[] camera,
            double planeDistance,
            double viewWindowWidth,
            double viewWindowHeight) {
        this.distanceFromCamera[0] = 
                DataPoint.pointDistance(camera, visualisationCoords[0]);
        this.distanceFromCamera[1] = 
                DataPoint.pointDistance(camera, visualisationCoords[1]);
    }

}
