/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.StoreDurableSubscriberCursor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableTopicSubscription
extends PrefetchSubscription
implements UsageListener {
    private static final Log LOG = LogFactory.getLog(DurableTopicSubscription.class);
    private final ConcurrentHashMap<MessageId, Integer> redeliveredMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<ActiveMQDestination, Destination> destinations = new ConcurrentHashMap();
    private final SubscriptionKey subscriptionKey;
    private final boolean keepDurableSubsActive;
    private AtomicBoolean active = new AtomicBoolean();

    public DurableTopicSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, boolean keepDurableSubsActive) throws JMSException {
        super(broker, usageManager, context, info);
        this.pending = new StoreDurableSubscriberCursor(broker, context.getClientId(), info.getSubscriptionName(), info.getPrefetchSize(), this);
        this.pending.setSystemUsage(usageManager);
        this.pending.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
        this.keepDurableSubsActive = keepDurableSubsActive;
        this.subscriptionKey = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean isFull() {
        return !this.active.get() || super.isFull();
    }

    public void gc() {
    }

    public void unmatched(MessageReference node) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)5);
        ack.setMessageID(node.getMessageId());
        node.getRegionDestination().acknowledge(this.getContext(), this, ack, node);
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
        super.add(context, destination);
        if (this.destinations.containsKey(destination.getActiveMQDestination())) {
            return;
        }
        this.destinations.put(destination.getActiveMQDestination(), destination);
        if (destination.getMessageStore() != null) {
            TopicMessageStore store = (TopicMessageStore)destination.getMessageStore();
            try {
                this.enqueueCounter += (long)store.getMessageCount(this.subscriptionKey.getClientId(), this.subscriptionKey.getSubscriptionName());
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Failed to retrieve eunqueueCount from store " + e);
                jmsEx.setLinkedException(e);
                throw jmsEx;
            }
        }
        if (this.active.get() || this.keepDurableSubsActive) {
            Topic topic = (Topic)destination;
            topic.activate(context, this);
            if (this.pending.isEmpty(topic)) {
                topic.recoverRetroactiveMessages(context, this);
            }
        }
        this.dispatchPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(SystemUsage memoryManager, ConnectionContext context, ConsumerInfo info) throws Exception {
        if (!this.active.get()) {
            this.context = context;
            this.info = info;
            LOG.debug("Activating " + this);
            int prefetch = info.getPrefetchSize();
            if (prefetch > 0) {
                prefetch += prefetch / 2;
            }
            int depth = Math.max(prefetch, this.pending.getMaxAuditDepth());
            this.pending.setMaxAuditDepth(depth);
            if (!this.keepDurableSubsActive) {
                for (Topic topic : this.destinations.values()) {
                    this.add(context, topic);
                    topic.activate(context, this);
                }
            }
            PendingMessageCursor pendingMessageCursor = this.pending;
            synchronized (pendingMessageCursor) {
                this.pending.setSystemUsage(memoryManager);
                this.pending.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
                this.pending.start();
                if (this.pending.isEmpty()) {
                    for (Topic topic : this.destinations.values()) {
                        topic.recoverRetroactiveMessages(context, this);
                    }
                }
            }
            this.active.set(true);
            this.dispatchPending();
            this.usageManager.getMemoryUsage().addUsageListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean keepDurableSubsActive) throws Exception {
        LOG.debug("Deactivating " + this);
        this.active.set(false);
        this.usageManager.getMemoryUsage().removeUsageListener(this);
        Object object = this.pending;
        synchronized (object) {
            this.pending.stop();
        }
        if (!keepDurableSubsActive) {
            for (Topic topic : this.destinations.values()) {
                topic.deactivate(this.context, this);
            }
        }
        for (MessageReference messageReference : this.dispatched) {
            Integer count = this.redeliveredMessages.get(messageReference.getMessageId());
            if (count != null) {
                this.redeliveredMessages.put(messageReference.getMessageId(), count + 1);
            } else {
                this.redeliveredMessages.put(messageReference.getMessageId(), 1);
            }
            if (keepDurableSubsActive && this.pending.isTransient()) {
                PendingMessageCursor pendingMessageCursor = this.pending;
                synchronized (pendingMessageCursor) {
                    this.pending.addMessageFirst(messageReference);
                    continue;
                }
            }
            messageReference.decrementReferenceCount();
        }
        object = this.dispatched;
        synchronized (object) {
            this.dispatched.clear();
        }
        if (!keepDurableSubsActive && this.pending.isTransient()) {
            object = this.pending;
            synchronized (object) {
                try {
                    this.pending.reset();
                    while (this.pending.hasNext()) {
                        MessageReference messageReference = this.pending.next();
                        messageReference.decrementReferenceCount();
                        this.pending.remove();
                    }
                }
                finally {
                    this.pending.release();
                }
            }
        }
        this.prefetchExtension = 0;
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        MessageDispatch md = super.createMessageDispatch(node, message);
        Integer count = this.redeliveredMessages.get(node.getMessageId());
        if (count != null) {
            md.setRedeliveryCounter(count);
        }
        return md;
    }

    public void add(MessageReference node) throws Exception {
        if (!this.active.get() && !this.keepDurableSubsActive) {
            return;
        }
        super.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddRecoveredMessage(MessageReference message) throws Exception {
        PendingMessageCursor pendingMessageCursor = this.pending;
        synchronized (pendingMessageCursor) {
            this.pending.addRecoveredMessage(message);
        }
    }

    public int getPendingQueueSize() {
        if (this.active.get() || this.keepDurableSubsActive) {
            return super.getPendingQueueSize();
        }
        return 0;
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        throw new UnsupportedOperationException("You cannot dynamically change the selector for durable topic subscriptions");
    }

    protected boolean canDispatch(MessageReference node) {
        return this.active.get();
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
        node.getRegionDestination().acknowledge(context, this, ack, node);
        this.redeliveredMessages.remove(node.getMessageId());
        node.decrementReferenceCount();
    }

    public synchronized String toString() {
        return "DurableTopicSubscription-" + this.getSubscriptionKey() + ", id=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", total=" + this.enqueueCounter + ", pending=" + this.getPendingQueueSize() + ", dispatched=" + this.dispatchCounter + ", inflight=" + this.dispatched.size() + ", prefetchExtension=" + this.prefetchExtension;
    }

    public SubscriptionKey getSubscriptionKey() {
        return this.subscriptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.pending;
        synchronized (object) {
            try {
                this.pending.reset();
                while (this.pending.hasNext()) {
                    MessageReference node = this.pending.next();
                    node.decrementReferenceCount();
                }
            }
            finally {
                this.pending.release();
                this.pending.clear();
            }
        }
        object = this.dispatched;
        synchronized (object) {
            for (MessageReference node : this.dispatched) {
                node.decrementReferenceCount();
            }
            this.dispatched.clear();
        }
        this.setSlowConsumer(false);
    }

    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage && oldPercentUsage >= 90) {
            try {
                this.dispatchPending();
            }
            catch (IOException e) {
                LOG.warn("problem calling dispatchMatched", e);
            }
        }
    }

    protected boolean isDropped(MessageReference node) {
        return false;
    }
}

