/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.antlr.tool.ErrorManager;

public class Stats {
    public static double stddev(int[] nArray) {
        int n = nArray.length;
        if (n <= 1) {
            return 0.0;
        }
        double d = Stats.avg(nArray);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += ((double)nArray[i] - d) * ((double)nArray[i] - d);
        }
        return Math.sqrt(d2 /= (double)(n - 1));
    }

    public static double avg(int[] nArray) {
        double d = 0.0;
        int n = nArray.length;
        if (n == 0) {
            return 0.0;
        }
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        if (d >= 0.0) {
            return d / (double)n;
        }
        return 0.0;
    }

    public static int min(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static void writeReport(String string, String string2) {
        String string3 = Stats.getAbsoluteFileName(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        file2.mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            printStream.println(string2);
            printStream.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.internalError("can't write stats to " + string3, iOException);
        }
    }

    public static String getAbsoluteFileName(String string) {
        return System.getProperty("user.home") + File.separator + "antlrworks" + File.separator + string;
    }
}

