/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobLocation;
import org.apache.kahadb.util.ByteSequence;

public class JobImpl
implements Job {
    private final JobLocation jobLocation;
    private final byte[] payload;

    protected JobImpl(JobLocation location, ByteSequence bs) {
        this.jobLocation = location;
        this.payload = new byte[bs.getLength()];
        System.arraycopy(bs.getData(), bs.getOffset(), this.payload, 0, bs.getLength());
    }

    public String getJobId() {
        return this.jobLocation.getJobId();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getPeriod() {
        return this.jobLocation.getPeriod();
    }

    public int getRepeat() {
        return this.jobLocation.getRepeat();
    }

    public long getStart() {
        return this.jobLocation.getStartTime();
    }

    public long getDelay() {
        return this.jobLocation.getDelay();
    }

    public String getCronEntry() {
        return this.jobLocation.getCronEntry();
    }

    public String getNextExecutionTime() {
        return JobImpl.getDateTime(this.jobLocation.getNextTime());
    }

    public String getStartTime() {
        return JobImpl.getDateTime(this.getStart());
    }

    public static long getDataTime(String value) throws Exception {
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = dfm.parse(value);
        return date.getTime();
    }

    public static String getDateTime(long value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(value);
        return dateFormat.format(date);
    }
}

