/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.transaction.LocalTransaction;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.transaction.Transaction;
import org.apache.activemq.transaction.XATransaction;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.WrappedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionBroker
extends BrokerFilter {
    private static final Log LOG = LogFactory.getLog(TransactionBroker.class);
    private TransactionStore transactionStore;
    private Map<TransactionId, XATransaction> xaTransactions = new LinkedHashMap<TransactionId, XATransaction>();
    private ActiveMQMessageAudit audit;

    public TransactionBroker(Broker next, TransactionStore transactionStore) {
        super(next);
        this.transactionStore = transactionStore;
    }

    public void start() throws Exception {
        this.transactionStore.start();
        try {
            final ConnectionContext context = new ConnectionContext();
            context.setBroker(this);
            context.setInRecoveryMode(true);
            context.setTransactions(new ConcurrentHashMap<TransactionId, Transaction>());
            context.setProducerFlowControl(false);
            final ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setMutable(true);
            producerExchange.setConnectionContext(context);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            final ConsumerBrokerExchange consumerExchange = new ConsumerBrokerExchange();
            consumerExchange.setConnectionContext(context);
            this.transactionStore.recover(new TransactionRecoveryListener(){

                public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] aks) {
                    try {
                        int i;
                        TransactionBroker.this.beginTransaction(context, xid);
                        for (i = 0; i < addedMessages.length; ++i) {
                            TransactionBroker.this.send(producerExchange, addedMessages[i]);
                        }
                        for (i = 0; i < aks.length; ++i) {
                            TransactionBroker.this.acknowledge(consumerExchange, aks[i]);
                        }
                        TransactionBroker.this.prepareTransaction(context, xid);
                    }
                    catch (Throwable e) {
                        throw new WrappedException(e);
                    }
                }
            });
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            throw IOExceptionSupport.create("Recovery Failed: " + cause.getMessage(), cause);
        }
        this.next.start();
    }

    public void stop() throws Exception {
        this.transactionStore.stop();
        this.next.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        ArrayList<TransactionId> txs = new ArrayList<TransactionId>();
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            for (Transaction transaction : this.xaTransactions.values()) {
                if (!transaction.isPrepared()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("prepared transaction: " + transaction.getTransactionId()));
                }
                txs.add(transaction.getTransactionId());
            }
        }
        TransactionId[] rc = new XATransactionId[txs.size()];
        txs.toArray(rc);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("prepared transacton list size: " + rc.length));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        if (xid.isXATransaction()) {
            XATransaction transaction = null;
            Map<TransactionId, XATransaction> map = this.xaTransactions;
            synchronized (map) {
                transaction = this.xaTransactions.get(xid);
                if (transaction != null) {
                    return;
                }
                transaction = new XATransaction(this.transactionStore, (XATransactionId)xid, this, context.getConnectionId());
                this.xaTransactions.put(xid, transaction);
            }
        } else {
            ConcurrentHashMap<TransactionId, Transaction> transactionMap = context.getTransactions();
            Transaction transaction = (Transaction)transactionMap.get(xid);
            if (transaction != null) {
                throw new JMSException("Transaction '" + xid + "' has already been started.");
            }
            transaction = new LocalTransaction(this.transactionStore, (LocalTransactionId)xid, context);
            transactionMap.put(xid, transaction);
        }
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, false);
        return transaction.prepare();
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.commit(onePhase);
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.rollback();
    }

    public void forgetTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        ConnectionContext context = consumerExchange.getConnectionContext();
        Transaction originalTx = context.getTransaction();
        Transaction transaction = null;
        if (ack.isInTransaction()) {
            transaction = this.getTransaction(context, ack.getTransactionId(), false);
        }
        context.setTransaction(transaction);
        try {
            this.next.acknowledge(consumerExchange, ack);
        }
        finally {
            context.setTransaction(originalTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        ConnectionContext context = producerExchange.getConnectionContext();
        Transaction originalTx = context.getTransaction();
        Transaction transaction = null;
        Synchronization sync = null;
        if (message.getTransactionId() != null && (transaction = this.getTransaction(context, message.getTransactionId(), false)) != null) {
            sync = new Synchronization(){

                public void afterRollback() {
                    if (TransactionBroker.this.audit != null) {
                        TransactionBroker.this.audit.rollback(message);
                    }
                }
            };
            transaction.addSynchronization(sync);
        }
        if (this.audit == null || !this.audit.isDuplicate(message)) {
            context.setTransaction(transaction);
            try {
                this.next.send(producerExchange, message);
            }
            finally {
                context.setTransaction(originalTx);
            }
        } else {
            if (sync != null && transaction != null) {
                transaction.removeSynchronization(sync);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IGNORING duplicate message " + message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        Iterator<Transaction> iter = context.getTransactions().values().iterator();
        while (iter.hasNext()) {
            try {
                Transaction transaction = iter.next();
                transaction.rollback();
            }
            catch (Exception e) {
                LOG.warn((Object)"ERROR Rolling back disconnected client's transactions: ", (Throwable)e);
            }
            iter.remove();
        }
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            ArrayList<XATransaction> txs = new ArrayList<XATransaction>();
            for (XATransaction tx : this.xaTransactions.values()) {
                if (!tx.getConnectionId().equals(info.getConnectionId()) || tx.isPrepared()) continue;
                txs.add(tx);
            }
            for (XATransaction tx : txs) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    LOG.warn((Object)"ERROR Rolling back disconnected client's xa transactions: ", (Throwable)e);
                }
            }
        }
        this.next.removeConnection(context, info, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(ConnectionContext context, TransactionId xid, boolean mightBePrepared) throws JMSException, XAException {
        Map<TransactionId, XATransaction> transactionMap = null;
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            transactionMap = xid.isXATransaction() ? this.xaTransactions : context.getTransactions();
        }
        Transaction transaction = transactionMap.get(xid);
        if (transaction != null) {
            return transaction;
        }
        if (xid.isXATransaction()) {
            XAException e = new XAException("Transaction '" + xid + "' has not been started.");
            e.errorCode = -4;
            throw e;
        }
        throw new JMSException("Transaction '" + xid + "' has not been started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(XATransactionId xid) {
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            this.xaTransactions.remove(xid);
        }
    }

    public synchronized void brokerServiceStarted() {
        super.brokerServiceStarted();
        if (this.getBrokerService().isSupportFailOver() && this.audit == null) {
            this.audit = new ActiveMQMessageAudit();
        }
    }
}

