/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Comparator;
import net.sf.picard.util.Interval;
import net.sf.samtools.SAMFileHeader;

class IntervalCoordinateComparator
implements Comparator<Interval> {
    private final SAMFileHeader header;

    IntervalCoordinateComparator(SAMFileHeader header) {
        this.header = header;
    }

    @Override
    public int compare(Interval lhs, Interval rhs) {
        int rhsIndex;
        int lhsIndex = this.header.getSequenceIndex(lhs.getSequence());
        int retval = lhsIndex - (rhsIndex = this.header.getSequenceIndex(rhs.getSequence()));
        if (retval == 0) {
            retval = lhs.getStart() - rhs.getStart();
        }
        if (retval == 0) {
            retval = lhs.getEnd() - rhs.getEnd();
        }
        if (retval == 0) {
            if (lhs.isPositiveStrand() && rhs.isNegativeStrand()) {
                retval = -1;
            } else if (lhs.isNegativeStrand() && rhs.isPositiveStrand()) {
                retval = 1;
            }
        }
        if (retval == 0) {
            if (lhs.getName() == null) {
                if (rhs.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (rhs.getName() == null) {
                return 1;
            }
            return lhs.getName().compareTo(rhs.getName());
        }
        return retval;
    }
}

