/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.RestServlet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyFileServer {
    private Server jettyInstance;
    private AuthorisedUrlRepository urlRepository;

    public JettyFileServer(AuthorisedUrlRepository urlRepository) {
        this.urlRepository = urlRepository;
    }

    public void start(String resourceBase, int port) throws Exception {
        if (DirectoryLayout.getInstance().getConfiguration().getBoolean("filebroker", "jetty-debug")) {
            System.setProperty("DEBUG", "true");
        }
        this.jettyInstance = new Server();
        this.jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(this.jettyInstance);
        connector.setPort(port);
        this.jettyInstance.setConnectors(new Connector[]{connector});
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.jettyInstance, "/", false, false);
        root.getInitParams().put("org.eclipse.jetty.servlet.Default.aliases", "true");
        root.setResourceBase(resourceBase);
        root.addServlet(new ServletHolder((Servlet)new RestServlet(this.urlRepository, this.urlRepository.getRootUrl())), "/*");
        this.jettyInstance.start();
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }
}

