/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.workflow;

import bsh.EvalError;
import bsh.Interpreter;
import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.workflow.WorkflowWriter;
import fi.csc.microarray.client.workflow.api.WfApplication;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.GeneralFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkflowManager {
    static final Logger logger = Logger.getLogger(WorkflowManager.class);
    public static final String WORKFLOW_VERSION = "BSH/2";
    public static final String SCRIPT_EXTENSION = "bsh";
    String[] extensions = new String[]{"bsh"};
    public static final GeneralFileFilter FILE_FILTER = new GeneralFileFilter("Workflow in BeanShell format", new String[]{"bsh"});
    public File scriptDirectory;
    private ClientApplication application;

    public static void checkVersionHeaderLine(String line) throws IllegalArgumentException {
        if (!line.contains("BSH/2 ")) {
            throw new IllegalArgumentException("Script version not supported. Supported version is BSH/2, but script begins with " + line);
        }
    }

    public WorkflowManager(ClientApplication application) throws IOException {
        this.application = application;
        this.scriptDirectory = DirectoryLayout.getInstance().getUserDataDir();
    }

    public List<File> getWorkflows() {
        LinkedList<File> workflows = new LinkedList<File>();
        File[] scripts = this.scriptDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(WorkflowManager.SCRIPT_EXTENSION);
            }
        });
        if (scripts != null) {
            for (File script : scripts) {
                workflows.add(script);
            }
        }
        return workflows;
    }

    public void runScript(File file, AtEndListener listener) {
        try {
            this.runScript(file.toURI().toURL(), listener);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void runScript(final URL workflowUrl, final AtEndListener listener) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader in = null;
                boolean success = false;
                try {
                    in = new BufferedReader(new InputStreamReader(workflowUrl.openConnection().getInputStream()));
                    String line = in.readLine();
                    WorkflowManager.checkVersionHeaderLine(line);
                    in.close();
                    Interpreter i = WorkflowManager.this.initialiseBshEnvironment();
                    i.eval((Reader)new InputStreamReader(workflowUrl.openConnection().getInputStream()));
                    success = true;
                }
                catch (Throwable e) {
                    logger.warn((Object)"running workflow failed", e);
                    String workflowName = "";
                    try {
                        workflowName = " " + workflowUrl.getPath().substring(workflowUrl.getPath().lastIndexOf(47) + 1);
                    }
                    catch (Exception we) {
                        // empty catch block
                    }
                    WorkflowManager.this.application.showDialog("Running workflow" + workflowName + " failed.", "The most common reason for a workflow failure is that the data used as an input for the workflow is not compatible with the tools in the workflow. This causes one of tools to fail and aborting the rest of the workflow.\n\nTo get an idea of why a tool has failed, please see the tool specific failure window.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, false, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, null);
                }
                finally {
                    if (listener != null) {
                        listener.atEnd(success);
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public Interpreter initialiseBshEnvironment() {
        Interpreter i = new Interpreter();
        try {
            i.set("app", (Object)new WfApplication(Session.getSession().getApplication()));
        }
        catch (EvalError ee) {
            throw new RuntimeException("BeanShell console failed to open: " + ee.getMessage());
        }
        return i;
    }

    public void saveSelectedWorkflow(File selectedFile) throws IOException {
        WorkflowWriter writer = new WorkflowWriter();
        StringBuffer script = writer.writeWorkflow(this.application.getSelectionManager().getSelectedDataBean());
        this.saveScript(selectedFile, script);
        if (!writer.writeWarnings().isEmpty()) {
            String details = "";
            for (String warning : writer.writeWarnings()) {
                details = details + warning + "\n";
            }
            this.application.showDialog("Workflow not fully saved", "Some parts of workflow structure are not supported by current workflow system and they were skipped. The rest of the workflow was successfully saved.", details, DialogInfo.Severity.INFO, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScript(File scriptFile, StringBuffer currentWorkflowScript) throws IOException {
        try (PrintWriter scriptOut = null;){
            scriptOut = new PrintWriter(new OutputStreamWriter(new FileOutputStream(scriptFile)));
            scriptOut.print(currentWorkflowScript.toString());
        }
    }

    public File getScriptDirectory() {
        return this.scriptDirectory;
    }
}

