/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Utils;
import java.awt.Color;
import java.util.Collection;

public class RulerTrack
extends Track {
    private static final int textY = 10;
    private static final int boxY = 12;
    private static final int MINOR_STEPS = 10;
    private static final int TICK_W = 2;
    private static final int BOX_HEIGHT = 4;
    private static final int TICK_H = 4;

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Region region = this.getView().getBpRegion();
        long magnitude = (long)Math.pow(10.0, (int)Math.log10(region.getLength().longValue()));
        long start = region.start.bp - region.start.bp % magnitude;
        int steps = (int)Math.ceil((double)region.getLength().longValue() / (double)magnitude) + 1;
        long end = start + (long)steps * magnitude;
        for (long bp = start; bp <= end; bp += magnitude) {
            int x = this.getView().bpToTrack(new BpCoord(bp, region.start.chr));
            String text = Utils.toHumanReadable(bp);
            drawables.add(new TextDrawable(x + 4, 10, text, Color.black));
            drawables.add(new RectDrawable(x - 2, 8, 2, 12, Color.black, Color.black));
        }
        boolean whiteStart = false;
        drawables.addAll(this.getRuler(new Region(start, end, region.start.chr), steps * 10, whiteStart));
        return drawables;
    }

    private Collection<Drawable> getRuler(Region bpRegion, int steps, boolean whiteStart) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        boolean isWhite = whiteStart;
        double increment = (double)bpRegion.getLength().longValue() / (double)steps;
        BpCoordDouble boxBp = new BpCoordDouble(bpRegion.start);
        float lastBoxX = this.getView().bpToTrackFloat(bpRegion.start).floatValue();
        float boxX = 0.0f;
        for (int i = 0; i < steps; ++i) {
            isWhite = !isWhite;
            Color c = isWhite ? Color.white : Color.black;
            boxBp = boxBp.move(increment);
            boxX = this.getView().bpToTrackFloat(boxBp.asBpCoord()).floatValue();
            drawables.add(new RectDrawable(Math.round(lastBoxX), 12, Math.round(boxX) - Math.round(lastBoxX), 4, c, null));
            lastBoxX = boxX;
        }
        float startX = this.getView().bpToTrackFloat(bpRegion.start).floatValue();
        float endX = boxX;
        drawables.add(new RectDrawable(Math.round(startX), 12, Math.round(endX) - Math.round(startX), 4, null, Color.black));
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
    }

    @Override
    public int getTrackHeight() {
        return 20;
    }

    @Override
    public String getTrackName() {
        return "ruler";
    }
}

