/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CigarItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Sequence;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class ReadPileTrack
extends Track {
    public static final Color CUTOFF_COLOR = Color.ORANGE;
    private DataThread refData;
    private Collection<Feature> referenceSequenceFeatures = new TreeSet<Feature>();
    private boolean highlightSNP = false;
    private Collection<Feature> reads = new TreeSet<Feature>();

    public ReadPileTrack(DataThread refData, Color fontColor) {
        this.refData = refData;
        this.layoutMode = this.defaultLayoutMode = LayoutTool.LayoutMode.FILL;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        char[] refSeq = this.highlightSNP ? ReadPileTrack.getReferenceArray(this.referenceSequenceFeatures, this.view, this.strand) : null;
        Iterator<Feature> readIter = this.reads.iterator();
        Feature read = null;
        TreeSet<Feature> dividedReads = new TreeSet<Feature>();
        HashSet<CigarItem.CigarItemType> splitters = new HashSet<CigarItem.CigarItemType>();
        splitters.add(CigarItem.CigarItemType.N);
        while (readIter.hasNext()) {
            read = readIter.next();
            if (!this.getView().requestIntersects(read.region)) {
                readIter.remove();
                continue;
            }
            dividedReads.addAll(Cigar.splitRead(read, splitters));
        }
        ArrayList<Integer> occupiedSpace = new ArrayList<Integer>();
        Iterator splittedReadIter = dividedReads.iterator();
        Feature splittedRead = null;
        while (splittedReadIter.hasNext()) {
            int layer;
            splittedRead = (Feature)splittedReadIter.next();
            if (!this.getView().viewIntersects(splittedRead.region)) continue;
            long widthInBps = splittedRead.region.getLength();
            Rectangle readRect = new Rectangle();
            readRect.x = this.getView().bpToTrack(splittedRead.region.start);
            readRect.width = (int)Math.floor(this.getView().bpWidth().floatValue() * (float)widthInBps);
            if (readRect.width < 2) {
                readRect.width = 2;
            }
            for (layer = 0; occupiedSpace.size() > layer && (Integer)occupiedSpace.get(layer) > readRect.x + 1; ++layer) {
            }
            int end = readRect.x + readRect.width;
            if (occupiedSpace.size() > layer) {
                occupiedSpace.set(layer, end);
            } else {
                occupiedSpace.add(end);
            }
            readRect.y = this.getYCoord(layer, 4);
            readRect.height = 4;
            boolean lastBeforeMaxStackingDepthCut = false;
            int maxHeight = this.getComponent().getHeight();
            if (this.getLayoutMode() != LayoutTool.LayoutMode.FULL) {
                int nextLayerY = this.getYCoord(layer + 1, 4);
                boolean bl = lastBeforeMaxStackingDepthCut = nextLayerY >= maxHeight;
                if (readRect.y > maxHeight) continue;
            }
            for (ReadPart readPart : Cigar.splitElements(splittedRead)) {
                widthInBps = readPart.getLength();
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(readPart.start);
                rect.width = (int)Math.floor(this.getView().bpWidth().floatValue() * (float)widthInBps);
                rect.y = readRect.y;
                rect.height = readRect.height;
                if (rect.width < 2) {
                    rect.width = 2;
                }
                String seq = readPart.getSequencePart();
                Cigar cigar = (Cigar)readPart.getRead().values.get((Object)DataType.CIGAR);
                if (readPart.isVisible()) {
                    if (rect.width < seq.length()) {
                        Color color = Color.gray;
                        if (lastBeforeMaxStackingDepthCut) {
                            color = CUTOFF_COLOR;
                        }
                        drawables.add(new RectDrawable(rect, color, color));
                        continue;
                    }
                    if ((Strand)((Object)readPart.getRead().values.get((Object)DataType.STRAND)) == Strand.REVERSE) {
                        StringBuffer buf = new StringBuffer(seq.toUpperCase());
                        seq = buf.toString().replace('A', 'x').replace('T', 'A').replace('x', 'T').replace('C', 'x').replace('G', 'C').replace('x', 'G');
                    }
                    float increment = this.getView().bpWidth().floatValue();
                    float startX = this.getView().bpToTrackFloat(readPart.start).floatValue();
                    for (int j = 0; j < seq.length(); ++j) {
                        char letter = seq.charAt(j);
                        long refIndex = j;
                        Color bg = Color.white;
                        Color border = Color.white;
                        long posInRef = (long)readPart.start.bp.intValue() + refIndex - (long)this.getView().getBpRegion().start.bp.intValue();
                        if (this.highlightSNP && posInRef >= 0L && posInRef < (long)refSeq.length && Character.toLowerCase(refSeq[(int)posInRef]) == Character.toLowerCase(letter)) {
                            border = bg = Color.gray;
                        } else {
                            switch (letter) {
                                case 'A': {
                                    border = bg = GBrowserConstants.charColors[0];
                                    break;
                                }
                                case 'C': {
                                    border = bg = GBrowserConstants.charColors[1];
                                    break;
                                }
                                case 'G': {
                                    border = bg = GBrowserConstants.charColors[2];
                                    break;
                                }
                                case 'T': {
                                    border = bg = GBrowserConstants.charColors[3];
                                    break;
                                }
                                case 'N': {
                                    bg = Color.white;
                                    border = Color.gray;
                                }
                            }
                        }
                        if (lastBeforeMaxStackingDepthCut) {
                            border = bg = CUTOFF_COLOR;
                        }
                        int x1 = Math.round(startX + (float)refIndex * increment);
                        int x2 = Math.round(startX + ((float)refIndex + 1.0f) * increment);
                        int width = Math.max(x2 - x1, 1);
                        drawables.add(new RectDrawable(x1, rect.y, width, 4, bg, border, cigar.toInfoString()));
                    }
                    continue;
                }
                if (readPart.getCigarItem() == null) continue;
                if (readPart.getCigarItem().getCigarItemType().equals((Object)CigarItem.CigarItemType.D)) {
                    Color color = Color.black;
                    rect.grow(0, -1);
                    drawables.add(new RectDrawable(rect, color, null));
                }
                if (!readPart.getCigarItem().getCigarItemType().equals((Object)CigarItem.CigarItemType.I)) continue;
                Color color = Color.black;
                drawables.add(new RectDrawable(rect.x, rect.y - 2, 3, rect.height + 4, color, color));
            }
        }
        return drawables;
    }

    private int getYCoord(int layer, int height) {
        return (layer + 1) * (height + 2);
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (Feature regCont : dataResult.getFeatures()) {
            if (regCont.values.get((Object)DataType.STRAND) != this.getStrand() || !regCont.values.containsKey((Object)DataType.SEQUENCE)) continue;
            this.reads.add(regCont);
        }
        if (dataResult.getStatus().getDataThread() == this.refData) {
            this.referenceSequenceFeatures.addAll(dataResult.getFeatures());
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.ID);
        this.addDataType(DataType.SEQUENCE);
        this.addDataType(DataType.STRAND);
        this.addDataType(DataType.CIGAR);
        if (this.highlightSNP && this.getView().getBpRegion().getLength() < (long)(this.getView().getWidth() * 2)) {
            this.addDataType(DataType.SEQUENCE);
        }
    }

    public void setSNPHighlight(boolean highlightSnp) {
        this.highlightSNP = highlightSnp;
    }

    public static char[] getReferenceArray(Collection<Feature> refFeatures, GBrowserView view, Strand strand) {
        char[] refSeq = new char[]{};
        Iterator<Feature> iter = refFeatures.iterator();
        refSeq = new char[view.getBpRegion().getLength().intValue() + 1];
        int startBp = view.getBpRegion().start.bp.intValue();
        int endBp = view.getBpRegion().end.bp.intValue();
        while (iter.hasNext()) {
            Feature feature = iter.next();
            if (!view.requestIntersects(feature.region)) {
                iter.remove();
                continue;
            }
            char[] readBases = null;
            if (feature.values.get((Object)DataType.SEQUENCE) == null) continue;
            readBases = strand == Strand.REVERSE ? Sequence.complement((String)feature.values.get((Object)DataType.SEQUENCE)).toCharArray() : ((String)feature.values.get((Object)DataType.SEQUENCE)).toCharArray();
            int readStart = feature.region.start.bp.intValue();
            int readNum = 0;
            int nextPos = 0;
            for (char c : readBases) {
                if ((nextPos = readStart + readNum++) < startBp || nextPos > endBp) continue;
                refSeq[nextPos - startBp] = c;
            }
        }
        return refSeq;
    }

    @Override
    public String getTrackName() {
        return "Reads";
    }

    @Override
    public int getTrackHeight() {
        return 100;
    }

    @Override
    public void initializeListener() {
        super.initializeListener();
        if (this.dataThreads != null && this.refData != null) {
            this.view.getQueueManager().addDataResultListener(this.refData, this);
        }
    }

    @Override
    public boolean isShowMoreCapable() {
        return true;
    }
}

