/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class RectDrawable
extends Drawable {
    public int width;
    public int height;
    public Color lineColor;

    public RectDrawable(int x, int y, int width, int height, Color fillColor, Color lineColor, String tooltipText) {
        super(x, y, fillColor);
        this.width = width;
        this.height = height;
        this.lineColor = lineColor;
    }

    public RectDrawable(int x, int y, int width, int height, Color fillColor, Color lineColor) {
        this(x, y, width, height, fillColor, lineColor, null);
    }

    public RectDrawable(Rectangle rect, Color fillColor, Color lineColor) {
        this(rect.x, rect.y, rect.width, rect.height, fillColor, lineColor, null);
    }

    @Override
    public void draw(Graphics2D g, int x, int y) {
        super.draw(g, x, y);
        if (this.color != null) {
            g.setPaint(this.color);
            g.fillRect(this.x + x, this.y + y, this.width, this.height);
        }
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
            g.drawRect(this.x + x, this.y + y, this.width - 1, this.height - 1);
        }
    }

    @Override
    public void upsideDown() {
        super.upsideDown();
        this.y -= this.height;
    }

    @Override
    public int getMaxY() {
        return this.y + this.height;
    }

    @Override
    public void expand(TrackContext context) {
        int maxY = context.trackHeight - 1;
        int newY = (int)((float)this.y * context.expansionRatio.floatValue());
        int newHeight = (int)((float)this.height * context.expansionRatio.floatValue());
        this.y = Math.min(newY, maxY);
        this.height = Math.min(newHeight, maxY - this.y);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }
}

