/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class QueueManager {
    private Map<DataThread, QueueContext> queues = new HashMap<DataThread, QueueContext>();
    private GBrowserView view;

    public QueueManager(GBrowserView view) {
        this.view = view;
    }

    private QueueContext createQueue(DataThread dataThread) {
        if (!this.queues.containsKey(dataThread)) {
            QueueContext context = new QueueContext();
            context.queue = new LinkedBlockingDeque<DataRequest>();
            try {
                dataThread.setQueue(context.queue);
                dataThread.setQueueManager(this);
                context.dataThread = dataThread;
                this.queues.put(dataThread, context);
                if (context.dataThread.isAlive()) {
                    System.err.println("Thread '" + context.dataThread + "' is poisoned, but still alive. " + "A new thread will be started for the upcoming requests.");
                    context.dataThread = (DataThread)context.dataThread.clone();
                }
                context.dataThread.runThread();
                return context;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void removeQueue(DataSource file) {
        this.queues.remove(file);
    }

    public void addDataRequest(DataThread dataThread, DataRequest req, Region dataRegion) {
        req.getStatus().setDataThread(dataThread);
        QueueContext context = this.queues.get(dataThread);
        context.dataThread.setDataRegion(dataRegion);
        context.queue.add(req);
    }

    public void addDataResultListener(DataThread dataThread, DataResultListener listener) {
        QueueContext qContext = this.queues.get(dataThread);
        if (qContext == null) {
            qContext = this.createQueue(dataThread);
        }
        qContext.listeners.add(listener);
    }

    public void processDataResult(DataResult dataResult) {
        for (DataResultListener listener : this.queues.get((Object)dataResult.getStatus().getDataThread()).listeners) {
            if (listener instanceof Track) {
                Track track = (Track)listener;
                if (!track.isSuitableViewLength()) continue;
                listener.processDataResult(dataResult);
                continue;
            }
            listener.processDataResult(dataResult);
        }
        this.view.redraw();
    }

    public void poisonAll() {
        for (Map.Entry<DataThread, QueueContext> entry : this.queues.entrySet()) {
            DataStatus status = new DataStatus();
            status.poison = true;
            DataRequest request = new DataRequest(new Region(), null, status);
            QueueContext context = entry.getValue();
            context.queue.add(request);
        }
    }

    public Collection<DataResultListener> getDataResultListeners(DataResult dataResult) {
        return this.queues.get((Object)dataResult.getStatus().getDataThread()).listeners;
    }

    public void clearDataResultListeners() {
        for (QueueContext context : this.queues.values()) {
            context.listeners.clear();
        }
    }

    private class QueueContext {
        public Queue<DataRequest> queue;
        public Collection<DataResultListener> listeners = new ArrayList<DataResultListener>();
        public DataThread dataThread;

        private QueueContext() {
        }
    }
}

