/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HorizontalView
extends GBrowserView
implements KeyListener {
    private Timer keyTimer;
    private Set<Integer> keySet = new HashSet<Integer>();

    public HorizontalView(GBrowserPlot parent, boolean movable, boolean zoomable, boolean selectable) {
        super(parent, movable, zoomable, selectable);
        this.getComponent().addKeyListener(this);
        this.getComponent().addMouseListener(this);
        this.getComponent().addMouseMotionListener(this);
        this.getComponent().addMouseWheelListener(this);
    }

    @Override
    protected void handleDrag(Point2D start, Point2D end, boolean disableDrawing) {
        double bpMove = this.trackToBp(start.getX()).minus(this.trackToBp(end.getX()));
        RegionDouble newRegion = this.bpRegion.clone();
        newRegion.move(bpMove);
        this.setBpRegion(newRegion);
        if (!disableDrawing) {
            this.parentPlot.redraw();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((this.zoomable || this.movable) && this.isNavigationKey(e.getKeyCode())) {
            this.keySet.add(e.getKeyCode());
            this.startKeyAnimation();
        }
    }

    public boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39;
    }

    public void startKeyAnimation() {
        if (this.keyTimer == null) {
            this.stopKeyAnimation();
            this.keyTimer = new Timer(33, new ActionListener(){
                private int i = 0;
                private long startTime = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean skipFrame = true;
                            boolean firstNotSkipped = true;
                            while (skipFrame || firstNotSkipped) {
                                if (!skipFrame) {
                                    firstNotSkipped = false;
                                }
                                if (HorizontalView.this.keySet.isEmpty() || !HorizontalView.this.getComponent().hasFocus()) {
                                    HorizontalView.this.stopKeyAnimation();
                                    break;
                                }
                                if (HorizontalView.this.zoomable) {
                                    double ZOOM_FACTOR = 0.78;
                                    if (HorizontalView.this.keySet.contains(38)) {
                                        HorizontalView.this.zoom(HorizontalView.this.getWidth() / 2, -0.78, skipFrame);
                                    }
                                    if (HorizontalView.this.keySet.contains(40)) {
                                        HorizontalView.this.zoom(HorizontalView.this.getWidth() / 2, 0.78, skipFrame);
                                    }
                                }
                                if (HorizontalView.this.movable) {
                                    double SPEED_DIVIDER = 50.0;
                                    if (HorizontalView.this.keySet.contains(37)) {
                                        HorizontalView.this.bpRegion.move((double)(-HorizontalView.this.getBpRegion().getLength().longValue()) / 50.0);
                                        HorizontalView.this.setBpRegion(HorizontalView.this.bpRegion);
                                        if (!skipFrame) {
                                            HorizontalView.this.parentPlot.redraw();
                                        }
                                    }
                                    if (HorizontalView.this.keySet.contains(39)) {
                                        HorizontalView.this.bpRegion.move((double)HorizontalView.this.getBpRegion().getLength().longValue() / 50.0);
                                        HorizontalView.this.setBpRegion(HorizontalView.this.bpRegion);
                                        if (!skipFrame) {
                                            HorizontalView.this.parentPlot.redraw();
                                        }
                                    }
                                }
                                i++;
                                skipFrame = (double)System.currentTimeMillis() > (double)startTime + 33.333333333333336 * (double)i;
                            }
                        }
                    });
                }
            });
            this.keyTimer.setRepeats(true);
            this.keyTimer.setCoalesce(false);
            this.keyTimer.start();
        }
    }

    private void stopKeyAnimation() {
        if (this.keyTimer != null) {
            this.keyTimer.stop();
            this.keyTimer = null;
            this.parentPlot.redraw();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((this.zoomable || this.movable) && this.isNavigationKey(e.getKeyCode())) {
            this.keySet.remove(e.getKeyCode());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

