/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.Delimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.HashMap;
import org.apache.log4j.Logger;
import sun.nio.ch.ChannelInputStream;

public class FileAnalyser {
    private static final Logger logger = Logger.getLogger(FileAnalyser.class);
    private File file;
    private Delimiter delimiter;
    private int linesOnFile;
    private boolean isAnalysed;
    private static final int DELIMETER_GUESS_INTERVAL_START = 10;

    public FileAnalyser(File file) {
        this.file = file;
        this.isAnalysed = false;
    }

    public void startAnalysing() throws IOException {
        Delimiter bestSuitable;
        HashMap<Delimiter, Integer> hitCountsOnFile = new HashMap<Delimiter, Integer>();
        for (Delimiter delim : Delimiter.values()) {
            hitCountsOnFile.put(delim, 0);
        }
        int lines = 0;
        int delimInterval = 10;
        try (BufferedReader buf = null;){
            String nextLine;
            buf = new BufferedReader(new InputStreamReader(new ChannelInputStream(new RandomAccessFile(this.file, "r").getChannel())));
            while ((nextLine = buf.readLine()) != null && !Thread.interrupted()) {
                if (++lines % delimInterval != 0) continue;
                bestSuitable = FileAnalyser.guessDelimeterForLine(nextLine);
                int delimeterCount = (Integer)hitCountsOnFile.get(bestSuitable);
                hitCountsOnFile.put(bestSuitable, ++delimeterCount);
                delimInterval *= 2;
            }
        }
        bestSuitable = null;
        int mostHits = 0;
        for (Delimiter delim : hitCountsOnFile.keySet()) {
            if ((Integer)hitCountsOnFile.get(delim) < mostHits) continue;
            bestSuitable = delim;
            mostHits = (Integer)hitCountsOnFile.get(delim);
        }
        logger.debug((Object)("File analysing ended. Total line count is " + lines + " and the best suitable delimeter is " + bestSuitable.getName()));
        this.delimiter = bestSuitable;
        this.linesOnFile = lines;
        this.isAnalysed = true;
    }

    private static Delimiter guessDelimeterForLine(String line) {
        HashMap<Delimiter, Integer> hitCountsOnLine = new HashMap<Delimiter, Integer>();
        for (Delimiter delim : Delimiter.values()) {
            String[] splittedLine = line.split(delim.toString());
            hitCountsOnLine.put(delim, splittedLine.length);
        }
        Delimiter bestSuitable = null;
        int mostHits = 0;
        for (Delimiter delim : hitCountsOnLine.keySet()) {
            if ((Integer)hitCountsOnLine.get(delim) < mostHits) continue;
            bestSuitable = delim;
            mostHits = (Integer)hitCountsOnLine.get(delim);
        }
        logger.debug((Object)("The best suitable delimeter for this line is " + bestSuitable.getName()));
        return bestSuitable;
    }

    public Delimiter getDelimiter() {
        if (this.isAnalysed) {
            return this.delimiter;
        }
        throw new IllegalStateException("File is not analysed yet");
    }

    public int getLinesOnFile() {
        if (this.isAnalysed) {
            return this.linesOnFile;
        }
        throw new IllegalStateException("File is not analysed yet");
    }

    public void setInputFile(File inputFile) {
        if (!this.isSameFileAs(inputFile)) {
            this.file = inputFile;
            this.delimiter = null;
            this.linesOnFile = -1;
            this.isAnalysed = false;
        }
    }

    public boolean isAnalysed() {
        return this.isAnalysed;
    }

    public boolean isSameFileAs(File file) {
        return this.file.equals(file);
    }
}

