/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.chipster.tools.ngs.LocalNGSPreprocess;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.tasks.LocalTaskExecutor;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.SimpleFileBrokerClient;
import fi.csc.microarray.messaging.SourceMessageListener;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.util.Collection;
import java.util.LinkedList;
import javax.jms.JMSException;

public class LocalServiceAccessor
implements ServiceAccessor {
    private static final String LOCAL_CATEGORY_NAME = "Local tools";
    private static final String LOCAL_MODULE_NAME = "local";
    private DataManager manager;
    private LinkedList<ToolModule> modules = new LinkedList();

    @Override
    public String checkRemoteServices() throws Exception {
        return "ok";
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String fetchDescriptions(Module primaryModule) throws Exception {
        ToolModule module = new ToolModule(LOCAL_MODULE_NAME);
        this.modules.add(module);
        SADLDescription sadl = new ChipsterSADLParser().parse(LocalNGSPreprocess.getSADL());
        ToolCategory category = new ToolCategory(LOCAL_CATEGORY_NAME);
        module.addHiddenToolCategory(category);
        OperationDefinition od = new OperationDefinition(sadl.getName().getID(), sadl.getName().getDisplayName(), category, sadl.getComment(), true, null, true);
        for (SADLDescription.Input input : sadl.inputs()) {
            if (input.getName().isNameSet()) {
                od.addInput(input.getName().getPrefix(), input.getName().getPostfix(), input.getName().getDisplayName(), input.getComment(), input.getType(), input.isOptional());
                continue;
            }
            od.addInput(input.getName(), input.getComment(), input.getType(), input.isOptional());
        }
        od.setOutputCount(sadl.outputs().size());
        for (SADLDescription.Parameter parameter : sadl.parameters()) {
            od.addParameter(Parameter.createInstance(parameter.getName(), parameter.getType(), parameter.getSelectionOptions(), parameter.getComment(), parameter.getFrom(), parameter.getTo(), parameter.getDefaultValues(), parameter.isOptional()));
        }
        return "";
    }

    @Override
    public FileBrokerClient getFileBrokerClient() throws Exception {
        return new SimpleFileBrokerClient();
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        try {
            return new LocalTaskExecutor(this.manager);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialise(DataManager manager, AuthenticationRequestListener authenticationRequestListener) throws Exception {
        this.manager = manager;
    }

    @Override
    public SourceMessageListener retrieveSourceCode(String id) throws Exception {
        throw new UnsupportedOperationException("not supported in standalone mode");
    }

    @Override
    public void sendFeedbackMessage(FeedbackMessage message) throws Exception {
        throw new UnsupportedOperationException("not supported in standalone mode");
    }

    @Override
    public Collection<ToolModule> getModules() {
        return this.modules;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }
}

