/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.RepositoryModule;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolRuntime;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolRepository {
    private static final Logger logger = Logger.getLogger(ToolRepository.class);
    private HashMap<String, ToolRuntime> runtimes = new HashMap();
    private List<RepositoryModule> modules = new LinkedList<RepositoryModule>();

    public ToolRepository(File workDir) throws AnalysisException {
        this.loadRuntimes(workDir);
        this.loadModuleDescriptions();
    }

    public synchronized ToolDescription getDescription(String id) {
        for (RepositoryModule module : this.modules) {
            ToolDescription desc = module.getDescription(id);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public synchronized boolean supports(String toolId) {
        for (RepositoryModule module : this.modules) {
            if (!module.isSupportedDescription(toolId)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<ModuleDescriptionMessage> getModuleDescriptions() {
        LinkedList<ModuleDescriptionMessage> moduleDescriptions = new LinkedList<ModuleDescriptionMessage>();
        for (RepositoryModule module : this.modules) {
            moduleDescriptions.add(module.getModuleDescriptionMessage());
        }
        return moduleDescriptions;
    }

    private synchronized void loadRuntimes(File workDir) throws AnalysisException {
        logger.info((Object)"loading runtimes");
        try {
            File runtimeConfig = new File(DirectoryLayout.getInstance().getConfDir(), "runtimes.xml");
            Document document = XmlUtil.parseReader(new FileReader(runtimeConfig));
            Element runtimesElement = (Element)document.getElementsByTagName("runtimes").item(0);
            for (Element runtimeElement : XmlUtil.getChildElements(runtimesElement, "runtime")) {
                String runtimeName = XmlUtil.getChildElement(runtimeElement, "name").getTextContent().trim();
                logger.info((Object)("loading runtime " + runtimeName));
                if (this.runtimes.containsKey(runtimeName)) {
                    logger.warn((Object)("runtime with the same name " + runtimeName + " already loaded, keeping the first one"));
                    continue;
                }
                boolean runtimeDisabled = runtimeElement.getAttribute("disabled").equals("true");
                if (runtimeDisabled) {
                    logger.info((Object)("runtime " + runtimeName + " disabled by config"));
                }
                Element handlerElement = XmlUtil.getChildElement(runtimeElement, "handler");
                String handlerClassName = XmlUtil.getChildElement(handlerElement, "class").getTextContent().trim();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("workDir", workDir.toString());
                for (Element parameterElement : XmlUtil.getChildElements(handlerElement, "parameter")) {
                    String paramName = XmlUtil.getChildElement(parameterElement, "name").getTextContent().trim();
                    String paramValue = XmlUtil.getChildElement(parameterElement, "value").getTextContent().trim();
                    parameters.put(paramName, paramValue);
                }
                AnalysisHandler handler = (AnalysisHandler)Class.forName(handlerClassName).getConstructor(HashMap.class).newInstance(parameters);
                if (handler.isDisabled()) {
                    runtimeDisabled = true;
                    logger.info((Object)("runtime " + runtimeName + " disabled as handler is disabled"));
                }
                ToolRuntime runtime = new ToolRuntime(runtimeName, handler, runtimeDisabled);
                this.runtimes.put(runtimeName, runtime);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    private synchronized void loadModuleDescriptions() throws AnalysisException {
        logger.info((Object)"loading modules");
        try {
            LinkedList<String> moduleLoadSummaries = new LinkedList<String>();
            for (String moduleDirName : DirectoryLayout.getInstance().getModulesDir().list()) {
                File moduleDir = new File(DirectoryLayout.getInstance().getModulesDir(), moduleDirName);
                if (!moduleDir.isDirectory()) continue;
                for (String moduleFilename : moduleDir.list()) {
                    File moduleFile;
                    if (!moduleFilename.endsWith("-module.xml") || !(moduleFile = new File(moduleDir, moduleFilename)).exists()) continue;
                    logger.info((Object)("loading tools specifications from: " + moduleFilename));
                    RepositoryModule module = new RepositoryModule(moduleDir, moduleFile, this.runtimes);
                    this.modules.add(module);
                    moduleLoadSummaries.add(module.getSummary());
                }
            }
            logger.info((Object)"------ tool summary ------ ");
            for (String summary : moduleLoadSummaries) {
                logger.info((Object)summary);
            }
            logger.info((Object)"------ tool summary ------ ");
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

