/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ProcessPool;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.SADLTool;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolDescriptionGenerator;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLGenerator;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class InterpreterAnalysisHandler
implements AnalysisHandler {
    static final Logger logger = Logger.getLogger(InterpreterAnalysisHandler.class);
    protected String interpreterCommand;
    protected String toolPath;
    protected String externalToolPath;
    protected ProcessPool processPool;
    protected boolean isDisabled = false;

    @Override
    public abstract AnalysisJob createAnalysisJob(JobMessage var1, ToolDescription var2, ResultCallback var3) throws AnalysisException;

    protected abstract String getSingleCommentLineSymbol();

    protected abstract String getStringDelimeter();

    protected abstract String getVariableNameSeparator();

    public InterpreterAnalysisHandler(HashMap<String, String> parameters) throws IOException {
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        String command = parameters.get("command");
        if (command == null || command.equals("")) {
            throw new IllegalArgumentException("Illegal command string: " + command);
        }
        String commandParameters = parameters.get("commandParameters");
        if (commandParameters != null) {
            command = command + " " + commandParameters;
        }
        this.interpreterCommand = command;
        this.toolPath = parameters.get("toolPath");
        this.externalToolPath = parameters.get("externalToolPath");
        if (this.externalToolPath == null) {
            throw new RuntimeException("externalToolPath must be set in runtimes.xml");
        }
        int poolSizeMin = configuration.getInt("comp", "r-process-pool-size-min");
        int poolSizeMax = configuration.getInt("comp", "r-process-pool-size-max");
        int poolTimeout = configuration.getInt("comp", "r-process-pool-timeout");
        int processUseCountMax = configuration.getInt("comp", "r-process-pool-process-use-count-max");
        int processLifetimeMax = configuration.getInt("comp", "r-process-pool-process-lifetime-max");
        try {
            this.processPool = new ProcessPool(new File(parameters.get("workDir")), this.interpreterCommand, poolSizeMin, poolSizeMax, poolTimeout, processUseCountMax, processLifetimeMax);
        }
        catch (Exception e) {
            this.isDisabled = true;
        }
    }

    @Override
    public ToolDescription handle(File moduleDir, String toolFilename, Map<String, String> params) throws AnalysisException {
        SADLDescription sadlDescription;
        SADLTool.ParsedScript parsedScript;
        FileInputStream scriptSource;
        File toolFile = new File(moduleDir, this.toolPath + File.separator + toolFilename);
        try {
            scriptSource = new FileInputStream(toolFile);
        }
        catch (FileNotFoundException e) {
            throw new AnalysisException("script source " + toolFile + " not found.");
        }
        try {
            parsedScript = new SADLTool(this.getSingleCommentLineSymbol()).parseScript(scriptSource);
        }
        catch (IOException e) {
            throw new AnalysisException(e);
        }
        try {
            sadlDescription = new ChipsterSADLParser().parse(parsedScript.SADL, toolFile.getName());
        }
        catch (SADLParser.ParseException e) {
            throw new AnalysisException(e);
        }
        ToolDescription ad = new ToolDescriptionGenerator().generate(sadlDescription, this);
        SADLGenerator.generate(sadlDescription);
        ad.setSADL(SADLGenerator.generate(sadlDescription));
        ad.setCommand(this.interpreterCommand);
        ad.setImplementation(parsedScript.source);
        ad.setSourceCode(parsedScript.source);
        ad.setToolFile(toolFile);
        ad.setModuleDir(moduleDir);
        int threadsMax = 2;
        try {
            threadsMax = DirectoryLayout.getInstance().getConfiguration().getInt("comp", "job-threads-max");
        }
        catch (Exception e) {
            logger.warn((Object)"could not read job-threads-max from configuration", (Throwable)e);
        }
        File commonScriptDir = new File(moduleDir.getParentFile(), "common" + this.toolPath);
        String vns = this.getVariableNameSeparator();
        String sd = this.getStringDelimeter();
        ad.setInitialiser("chipster" + vns + "tools" + vns + "path = " + sd + this.externalToolPath + sd + "\n" + "chipster" + vns + "common" + vns + "path = " + sd + commonScriptDir.getAbsolutePath() + sd + "\n" + "chipster" + vns + "module" + vns + "path = " + sd + moduleDir.getAbsolutePath() + sd + "\n" + "chipster" + vns + "threads" + vns + "max = " + sd + threadsMax + sd + "\n");
        return ad;
    }

    @Override
    public boolean isUptodate(ToolDescription description) {
        File scriptFile = description.getToolFile();
        return scriptFile.lastModified() <= description.getCreationTime();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }
}

