/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.util.Exceptions;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AnalysisJob
implements Runnable {
    public static String SCRIPT_SUCCESSFUL_STRING = "script-finished-succesfully";
    public static String SCRIPT_FAILED_STRING = "script-finished-unsuccesfully";
    public final String ERROR_MESSAGE_TOKEN = "Error";
    public final String CHIPSTER_NOTE_TOKEN = "CHIPSTER-NOTE:";
    private static final Logger logger = Logger.getLogger(AnalysisJob.class);
    protected JobMessage inputMessage;
    protected ResultCallback resultHandler;
    protected ToolDescription analysis;
    private Date receiveTime;
    private Date scheduleTime;
    private Date executionStartTime;
    private Date executionEndTime;
    private boolean constructed = false;
    private JobState state = JobState.NEW;
    private String stateDetail = "new job created.";
    private boolean toBeCanceled = false;
    protected ResultMessage outputMessage;

    public void construct(JobMessage inputMessage, ToolDescription analysis, ResultCallback resultHandler) {
        this.constructed = true;
        this.analysis = analysis;
        this.inputMessage = inputMessage;
        this.resultHandler = resultHandler;
        this.outputMessage = new ResultMessage();
        this.outputMessage.setJobId(this.getId());
        this.outputMessage.setReplyTo(inputMessage.getReplyTo());
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.constructed) {
                throw new IllegalStateException("you must call construct(...) first");
            }
            this.preExecute();
            if (this.getState() == JobState.RUNNING) {
                this.setExecutionStartTime(new Date());
                this.execute();
                this.setExecutionEndTime(new Date());
            }
            if (this.getState() == JobState.RUNNING) {
                this.postExecute();
            }
            if (this.getState() == JobState.RUNNING) {
                this.state = JobState.COMPLETED;
                this.stateDetail = "";
            }
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        catch (JobCancelledException jce) {
            this.setExecutionEndTime(new Date());
            logger.debug((Object)("job cancelled: " + this.getId()));
        }
        catch (Throwable e) {
            this.setExecutionEndTime(new Date());
            this.updateState(JobState.ERROR, "running tool failed");
            this.outputMessage.setErrorMessage("Running tool failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        finally {
            try {
                this.cleanUp();
            }
            catch (Throwable t) {
                logger.error((Object)"Error when cleaning up.", t);
            }
            this.resultHandler.removeRunningJob(this);
        }
    }

    public String getId() {
        return this.inputMessage.getJobId();
    }

    public synchronized void updateState(JobState newState, String stateDetail) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.state = newState;
        this.stateDetail = stateDetail;
    }

    public synchronized void updateStateDetailToClient(String newStateDetail) {
        if (this.state.equals((Object)JobState.CANCELLED)) {
            return;
        }
        this.stateDetail = newStateDetail;
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
        this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
    }

    public synchronized void updateStateToClient(JobState newState, String stateDetail) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.state = newState;
        this.stateDetail = stateDetail;
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
        this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
    }

    public JobState getState() {
        return this.state;
    }

    public void cancel() {
        logger.debug((Object)("Canceling job " + this.getId()));
        this.toBeCanceled = true;
        this.cancelRequested();
    }

    protected void cancelCheck() throws JobCancelledException {
        if (this.toBeCanceled) {
            this.updateState(JobState.CANCELLED, "");
            throw new JobCancelledException();
        }
    }

    protected abstract void cancelRequested();

    protected abstract void execute() throws JobCancelledException;

    protected void preExecute() throws JobCancelledException {
        if (!this.constructed) {
            throw new IllegalStateException("you must call construct(...) first");
        }
        this.updateStateToClient(JobState.RUNNING, "initialising");
    }

    protected void postExecute() throws JobCancelledException {
    }

    protected void cleanUp() {
    }

    public JobMessage getInputMessage() {
        return this.inputMessage;
    }

    public ResultMessage getResultMessage() {
        return this.outputMessage;
    }

    public Date getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }
}

