/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs.regions;

import fi.csc.chipster.tools.ngs.regions.FindOverlappingTool;
import fi.csc.chipster.tools.ngs.regions.RegionTool;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.java.JavaAnalysisHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.RegionOperations;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class FindOverlappingDatabaseTool
extends RegionTool {
    @Override
    public String getSADL() {
        return "TOOL FindOverlappingDatabaseTool.java: \"Match genomic regions against miRBase\" (Returns genomic regions which overlap with miRNA locations reported in miRBase. Adds name of the overlapping miRNA location to the output. Repeating matches are skipped for the TSV output, but included in the BED output.)\nINPUT data.bed: \"Set of regions\" TYPE GENERIC\nOUTPUT overlapping.bed: \"Overlapping regions\"\nOUTPUT overlapping.tsv: \"Overlapping regions as TSV\"\nPARAMETER database: \"Database\" TYPE [miRBase16: \"miRBase 16\"] DEFAULT miRBase16 (Which miRBase version is used for comparison?)PARAMETER min.overlap.bp: \"Minimum number of overlapping basepairs\" TYPE INTEGER FROM 1 DEFAULT 1 (How many basepairs are required to consider regions overlapping?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LinkedList<Feature> operate(LinkedList<List<Feature>> inputs, List<String> parameters) throws FileNotFoundException, IOException, URISyntaxException, GBrowserException {
        File dbDirectory = new File(((JavaAnalysisHandler)this.analysis.getHandler()).getParameters().get("externalToolPath"), "genomic_regions");
        List<Feature> dbRegions = new RegionOperations().loadFile(new File(dbDirectory, "miRBase16.bed"));
        inputs.add(dbRegions);
        LinkedList<String> newParameters = new LinkedList<String>();
        newParameters.add("first_augmented");
        newParameters.add(parameters.get(1));
        LinkedList<Feature> overlappingRegions = new FindOverlappingTool().operate(inputs, newParameters);
        FileOutputStream outputStream = null;
        try {
            RegionOperations tool = new RegionOperations();
            outputStream = new FileOutputStream(new File(this.jobWorkDir, this.analysis.getOutputFiles().get(1).getFileName().getID()));
            tool.printTSV(overlappingRegions, outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(outputStream);
            throw throwable;
        }
        IOUtils.closeIfPossible(outputStream);
        return overlappingRegions;
    }

    public static void main(String[] args) throws Exception {
        String testPath = "";
        FindOverlappingDatabaseTool tool = new FindOverlappingDatabaseTool();
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        p.put("externalToolPath", testPath);
        tool.analysis = new ToolDescription(new JavaAnalysisHandler(p));
        tool.analysis.addOutputFile(SADLDescription.Name.createName(testPath + File.separator + "overlapping.bed"), false);
        tool.analysis.addOutputFile(SADLDescription.Name.createName(testPath + File.separator + "overlapping.tsv"), false);
        List<Feature> file1 = new RegionOperations().loadFile(new File(testPath, "miRNAseq.bed"));
        LinkedList<List<Feature>> list = new LinkedList<List<Feature>>();
        list.add(file1);
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("");
        parameters.add("1");
        new RegionOperations().print(tool.operate(list, parameters), System.out);
    }
}

