/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.TsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import java.io.File;
import java.util.List;

public class SortTsv
extends JavaAnalysisJobBase {
    public static final String COLUMN_ID = "column";
    public static final String FIRST_ID = "first";
    public static final String SECOND_ID = "second";

    @Override
    public String getSADL() {
        return "TOOL SortTsv.java: \"Sort TSV\" (Sort a TSV file by chromosome and start position.)\nINPUT input.tsv: \"TSV file\" TYPE GENERIC\nOUTPUT sorted.tsv: \"Sorted TSV file\"\nPARAMETER column: \"Chromosome column\" TYPE [first: First, second: Second] DEFAULT First (Select the column that contains chromosome information.)\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.analysis.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(0).getFileName().getID());
            List<String> parameters = this.inputMessage.getParameters(JAVA_PARAMETER_SECURITY_POLICY, this.analysis);
            String columnString = parameters.get(0);
            int chrColumn = 0;
            if (SECOND_ID.equals(columnString)) {
                chrColumn = 1;
            }
            new TsvSorter().sort(inputFile, outputFile, chrColumn, chrColumn + 1, new TsvLineParser(new DataUrl(inputFile), chrColumn));
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

