/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import java.io.File;

public class SortGtf
extends JavaAnalysisJobBase {
    @Override
    public String getSADL() {
        return "TOOL SortGtf.java: \"Sort GTF\" (Sort a GTF file by chromosome and start position.)\nINPUT unsorted.gtf: \"GTF file\" TYPE GENERIC\nOUTPUT sorted.gtf: \"Sorted GTF file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.analysis.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.analysis.getOutputFiles().get(0).getFileName().getID());
            new TsvSorter().sort(inputFile, outputFile, GtfLineParser.Column.SEQNAME.ordinal(), GtfLineParser.Column.START.ordinal(), new GtfLineParser());
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

